/*
	in.pop3gwd, a POP3 proxy
	Copyright (C) 1997 Andrea Borgia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* pop3-gw.h	POP3 gateway main include file */
/* ------------------------------------------- */

/* 
Notice: the definition of POP3 may be found in RFC 1081 
and later modifications
*/


#ifndef _pop3_gw_h
#define _pop3_gw_h


#define DEBUG


/* all includes have been grouped here for the sake of readability */
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#ifdef __FreeBSD__
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <unistd.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/types.h>


/* internal in.pop3gwd function prototypes */

void parse_cmd_line(int argc, char *argv[], char log_id[], int maxlen, char *delim, 
	int *maxwait, int *port);

int connect_login(int first_filedes, int *remote_filedes, int maxlen, int maxwait, 
	char username[], char hostname[], int dest_port, const char termin[], 
	const char pos_re[], const char neg_re[], const char user_c[], 
	int *conn, int *in, int *out);

int get_remote_data(int client_filedes, char username[], char hostname[], 
	int maxlen, int maxwait, char termin[], char delim, const char user_c[],
	const char quit_c[], const char pos_re[], const char neg_re[], 
	int *in, int *out);

int readline(int filedes, char *line, int maxlen, int maxwait, const char termin[]);

int writen(int filedes, char *line, int nbytes, int maxwait);

void relay_data(int first_filedes, int second_filedes, int maxwait, int *in, int *out);


/* maximum length of POP3 input/output buffers */
#define MAX_IO_LEN 4096

/* common greeting / farewell text */
#define GREETING "POP3 proxy"

/* start logging asap and include pid */
#define LOG_OPT LOG_NDELAY|LOG_PID	

/* log as "other system daemons" */
#define LOG_OWNER LOG_DAEMON

/* normal, but significant, condition */
#define LOG_PRIO LOG_NOTICE


/* general utility constants */
#define GOOD	1
#define BAD	-1
#define FALSE	0
#define TRUE	1
#ifndef __FreeBSD__
#define MAX(A, B)	((A) > (B) ? (A) : (B))
#endif

#endif
