/*
	in.pop3gwd, a POP3 proxy
	Copyright (C) 1997 Andrea Borgia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* parse_cmd_line.c:	modify setup according to command line parameters */
/* ---------------------------------------------------------------------- */

#include "pop3-gw.h"



void parse_cmd_line(int argc, char *argv[], char log_id[], int maxlen, char *delim,
	int *maxwait, int *port) {

	char value[MAX_IO_LEN];
	int result;
	int count = 1;
	
	
	/* there is always at least 1 arg and that's the name of the program */
	strncpy(log_id, argv[0], maxlen);

	/* arguments must be in the form <id><value>, without blanks in between */
	while (count < argc) {
		strncpy(value, argv[count]+1, MAX_IO_LEN);
		if (strlen(value) != 0)
			switch (*argv[count]) {
				case 'd':	if (ispunct(value[0]))
							*delim = value[0];
						break;
						
				case 't':	result = (int)strtol(value, (char **)NULL, 10);
						if (result > 0)
							*maxwait = result;
						break;
				case 'p':	result = (int)strtol(value, (char **)NULL, 10);
						if (result > 0)
							*port = result;
						break;
			}
		count++;
	}
}
