/*
 Multiply two 32-bit numbers, V1 and V2, to produce
 a 64 bit result in the HI/LO registers.
 The algorithm is high-school math:

        A B
      x C D
      ------
      AD || BD
 AC || CB || 0

 where A and B are the high and low short words of V1,
 C and D are the short words of V2, AD is the product of
 A and D, and X || Y is (X << 16) + Y.
 Since the algorithm is programmed in C, we need to be
 careful not to overflow.
*/

static void long_multiply (reg_word v1, reg_word v2)
{
 register long a, b, c, d;
 register long x, y;

 a = (v1 >> 16) & 0xffff;
 b = v1 & 0xffff;
 c = (v2 >> 16) & 0xffff;
 d = v2 & 0xffff;

 LO = b * d;                   /* BD */
 x = a * d + c * b;            /* AD + CB */
 y = ((LO >> 16) & 0xffff) + x;

 LO = (LO & 0xffff) | ((y & 0xffff) << 16);
 HI = (y >> 16) & 0xffff;

 HI += a * c;                  /* AC */
}
