/*
 * PluSHS - Pluf Simple Hostname Scanner
 * Copyright (C) 2001, 2002 pluf <pluf@wanadoo.es>
 * 
 * plushs.h
 * 
 */
#include "config.h"

#define PROGRAM	"PluSHS"
#ifndef VERSION
#define VERSION	"1.2"
#endif
#define AUTHOR	"Pluf"
#define MAIL	"<pluf@wanadoo.es>"

#define	TITLE	""PROGRAM" v"VERSION" (c) 2001, 2002 by "AUTHOR" - "MAIL""

#define MAX_FILE	240		/* max length file */
#define MAX_PATTERN	40		/* max length pattern */
#define MAX_PLUGIN_LIST	MAX_PATTERN
#define LOG_FILE	"pattern"	/* log file name for options: -s and -x */
#define PLOGFILE	"PluginsLog"	/* plugins log file name */

#define DEFAULT_TIMEOUT	9		/* default timeout */
#define DEFAULT_WAIT	0		/* default wait time */
#define IPRANGE_SIZE	31		/* max ip range size */

/*
 * Functions prototypes 
 */
void	usage(int);
int	check_format_string(void);
int	executing(char *, FILE *, signed short*);
char	*get_vars(void);
int	error(int);
extern	int show_plugins_list(void);
extern	int activate_selected_plugins(char*);
extern	int load_plugins(char*);


/*
 * Comand line options (flags)
 */
struct progvars {
	int aflag;
	int cflag;
	int dflag;	
	int fflag;
	int lflag;
	int mflag;	
	int oflag;
	int sflag;
	int tflag;	
	int Tflag;
	int Pflag;
	int xflag;
	int wflag;
        int verbose;
        int timeout;
        int wait;
        int t;
};

struct progvars pv;

/* extern variables */
extern struct err_code err_code_list[];
extern float resolv_count;

/*
 * Set default value (-1) for iprange vector
 */ 
#define	INIT(x) {	\
register int i;		\
for(i = 0; i < 8; i++)	\
	x[i] = -1;	\
}

/* 
 * Check for non-digit character 
 * in iprange string
 */
#define CHECK_NON_DIGIT(x) {		\
if ((x != '\0') && (x != '-') &&	\
	(x != '\n') && (x != '.'))	\
	if (isdigit((int)x) == 0)	\
		error(7);		\
}	

/* 
 * These includes set output format 
 */ 
#define SA		"\n[a] %d-%d"		
#define SB		"\n [b] %d-%d"
#define SC		"\n  [c] %d-%d"
#define SD_C		"\n      \033[0;37m%d.%d.%d.%-4d\033[0m \033[0;33m==>\033[0m %s"
#define SD_NOC		"\n      %d.%d.%d.%d ==> %s"
#define SALIAS_C	"\n      		         \033[0;36m(a)\033[0m -> %s"
#define SALIAS_NOC	"\n                       (a) -> %s"
#define TIMEOUT_C	"\033[32mtimeout\033[0m"
#define TIMEOUT_NOC	"timeout"
#define FOUND_C		" \033[31m(found pattern)\033[0m"
#define FOUND_NOC	" (found pattern)"

#define SD	(((pv.oflag||pv.mflag) || pv.cflag)? SD_NOC: SD_C)
#define SALIAS  (((pv.oflag||pv.mflag) || pv.cflag)? SALIAS_NOC: SALIAS_C)
#define TIMEOUT (((pv.oflag||pv.mflag) || pv.cflag)? TIMEOUT_NOC: TIMEOUT_C)
#define FOUND	(((pv.oflag||pv.mflag) || pv.cflag)? FOUND_NOC: FOUND_C)

#define SFLAGS	((pv.oflag||pv.mflag)? fildes: stdout)
#define DESC	((pv.oflag||pv.mflag)? file: stdout)

/* 
 * Used for -e option.
 */
/* struct simbols buffers sizes */
#define FORMAT_SIZE     255
#define MAKE_SIZE       500
#define STRING_SIZE	MAKE_SIZE
#define HOSTNAME_SIZE	FORMAT_SIZE

/* macros for flags field */
#define FMT_DAEMON      0x0001

struct simbols {
	char format[FORMAT_SIZE+1];	/* comand line string */
	char make[MAKE_SIZE+1];		/* system() function argument */
	char string[MAKE_SIZE+1];	/* system() function argument */
	char hostname[HOSTNAME_SIZE+1];	/* hostname */
	char ip[15];			/* ip address */
	int flags;			/* flags for get_vargs() function */
} vars;

