/*
 *      PluSHS - Pluf Simple Hostname Scanner
 *      Copyright (C) 2001, 2002 pluf <pluf@wanadoo.es> 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * plugins.c
 * 
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#if defined(HAVE_STRINGS_H) && (defined(SOLARIS) || defined(AIX))
#include <strings.h>
#else
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "plugins.h"
#include "plist.h"
#include "plushs.h"

/* 
 * Plugins functions (only for plugins)
 */
int
pmessage(const char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	vfprintf((pv.oflag)?pfildes: stdout, format, ap);	
	va_end(ap);

	fflush(pfildes);

	return (0);
}

void
pbanner(id, pname)
	int id;
	char *pname;
{
 pmessage("\n|==========================================================================|\n");
 pmessage("| Plugin #%d. %s\n", id, pname);
 pmessage("|==========================================================================|\n");
}


int
show_plugins_list(void)
{
	register int i = 0;

	printf("
\033[31m[ Plugins List ]\033[0m

Id       Description
------------------------------------------------------------------------\n");

	while (plist[i].p_id != 0) {
		printf("\033[1m[\033[0m\033[32m%2.0d\033[0m\033[1m]    +\033[0m %s.\n", 
						plist[i].p_id, plist[i].p_name);
		++i;
	}
	
	putchar('\n');

	return (0);
}

int
p_activate(pid)
	int pid;
{
	int x;

	for (x = 0; plist[x].p_id != 0; x++)
		if (pid != 0 && plist[x].p_id == pid)
			plist[x].set = 1;

	return (0);
}

int
activate_selected_plugins(ids)
	char *ids;
{
	int i = 0, j = 0;
	char buf[3];

	/* some plugins */
	do {
		if (j > 3)
			return (-1);

		if (*(ids + i) == ',') {
			buf[j] = '\0';			
			p_activate(atoi(buf));

			bzero((char*)buf, sizeof(buf));
			j = 0;
		}
		else {
			buf[j] = *(ids + i);
			++j;
		}
	}
	while (*(ids + i) != '\0' && ++i);	

	/* one plugin */
	if (i == 1)
		p_activate(atoi(buf));

	return (0);
}

int
load_plugins(ip)
	char *ip;
{
	register int i;

	for (i = 0; plist[i].p_id != 0; i++)
		if (plist[i].set)
			plist[i].f(ip);

	return (0);
}
