/*
 *      PluSHS - Pluf Simple Hostname Scanner
 *      Copyright (C) 2001, 2002 pluf <pluf@wanadoo.es> 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * errors.c
 *
 */
#include <stdio.h>
#include <stdlib.h>

#include "plushs.h"

extern int errno;

struct err_code {
	int type;
	int action;
	char message[40];
};

struct err_code err_code_list[] = {
	{ 1, 1, "log file too long"},
	{ 2, 1, "pattern too long"},
	{ 3, 1, "ip-file too long"},
	{ 4, 1, "patterns list file too long"},
	{ 5, 1, "string too long"},
	{ 6, 1, "ip addresses range too long"},
	{ 7, 1, "ip address format incorrect"},
	{ 8, 1, "plugins list too long"},
	{ 9, 1, "reading patterns list file, fopen()"},
	{ 10, 1, "openning log file, fopen()"},
	{ 11, 1, "openning plugins log file, fopen()"},
	{ 12, 1, "openning patterns log file, fopen()"},
	{ 13, 1, "reading ip-file, fopen()"}
};

/*
 * Show error messages
 */
int
error(type)
        int type;
{
	fprintf(stderr, "%s - ", err_code_list[type-1].action?
					"[error]": "[warning]");
	if (errno)
		perror(err_code_list[type-1].message);
	else
		fprintf(stderr, "%s\n", err_code_list[type-1].message);	
	
	if (err_code_list[type-1].action != 0)
		exit(err_code_list[type-1].action);
	else
		return (0);
}
