/* 
 * video.c
 * sources came from ansi.c (ATP sources) by
 * Thomas McWilliams & Rene Cougnenc
 *
 * heavily modified by Davide Barbieri (C) 1996 1997
 * modified for FreeBSD use by Tim Vanderhoek
 * see file COPYING for more information on copyright policy
 */

#ifdef _HAVE_PARAM_H
#include <sys/param.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#if defined(BSD)
#include <termios.h>
#endif

#include "video.h"
#include "main.h"

struct winsize w;


void cls()               /* Clear screen & home cursor */
{
  printf("%c[2J%c[H",ESC,ESC);
}

void clear()             /* Reset Attributes          */
{
  printf("%c[0m",ESC );
}

void high()              /* HigLitht  (or BoldFace )  */
{
  printf("%c[1m",ESC);
}

void blink()             /* blink mode                */
{
  printf("%c[5m",ESC);
}

void deleol()            /* del to end of line        */
{
  printf("%c[K",ESC);
}

void reverse()           /* Revers video mode         */
{
  printf("%c[7m",ESC);
}

/*------------- Foreground colors ---------------------*/
void black()
{
  if( color )
    printf("%c[30m",ESC);
}

void red()
{
  if( color )
    printf("%c[31m",ESC);
}

void green()
{
  if( color )
    printf("%c[32m",ESC);
}

void yellow()
{
  if( color )
    printf("%c[33m",ESC);
}

void blue()
{
  if( color )
    printf("%c[34m",ESC);
}

void magenta()
{
  if( color )
      printf("%c[35m",ESC);
}

void cyan()
{
  if( color )
    printf("%c[36m",ESC);
}

void white()
{
  if( color )
    printf("%c[37m",ESC);
}

/*------------- BackGround colors ---------------------*/
void bblack()
{
  if( color )
    printf("%c[40m",ESC);
}

void bred()
{
  if( color )
    printf("%c[41m",ESC);
}

void bgreen()
{
  if( color )
    printf("%c[42m",ESC);
}

void byellow()
{
  if( color )
    printf("%c[43m",ESC);
}

void bblue()
{
  if( color )
    printf("%c[44m",ESC);
}

void bmagenta()
{
  if( color )
      printf("%c[45m",ESC);
}

void bcyan()
{
  if( color )
    printf("%c[46m",ESC);
}

void bwhite()
{
  if( color )
    printf("%c[47m",ESC);
}

int rows(){
  int fd;
  int Rows=0;

  if ((fd = open ("/dev/tty", O_RDONLY)) != -1) {
    if (ioctl (fd, TIOCGWINSZ, &w) != -1) {
      Rows = w.ws_row;
    }
    close (fd);
  }
  return(Rows);
}

int cols(){
  int fd;
  int Cols=0;

  if ((fd = open ("/dev/tty", O_RDONLY)) != -1) {
    if (ioctl (fd, TIOCGWINSZ, &w) != -1) {
      Cols = w.ws_col;
    }
    close (fd);
  }
  return(Cols);
}

/*----------- Cursor position ---------------------------*/

void locate( x , y )
int x, y;
{
  printf("%c[%d;%dH",ESC,y,x);
}

void up(nb)          /* Cursor Up default 1 */
int nb;
{
  if( ! nb ) nb = 1 ; 
  printf("%c[%dA",ESC,nb);
}

void dn(nb)        /* Cursor down default 1 */
int nb;
{
  if( ! nb ) nb = 1 ;
  printf("%c[%dB",ESC,nb);
}

void right(nb)        /* Cursor right default 1 */
int nb;
{
  if( ! nb ) nb = 1 ;
  printf("%c[%dC",ESC,nb);
}

void left(nb)        /* Cursor left default 1 */
int nb;
{
  if( ! nb ) nb = 1 ;
  printf("%c[%dD",ESC,nb);
}

  
/*-------- other stuffs -------------*/

int get_ch() {
  int file;
  char return_char;
#if defined(BSD)
  struct termios newterm, oldterm;
#else
  struct termio newterm, oldterm;
#endif
  file = open("/dev/tty", O_RDONLY);
  if (file == -1)
    return (0);
#if defined(BSD)
  ioctl(file,TIOCGETA,&oldterm);
  memcpy (&newterm,&oldterm,sizeof(struct termios));
  /* printf() doesn't seem to flush the output unless given a \n.  I
   * don't actually know why... */
#else
  ioctl(file,TCGETA,&oldterm);
  memcpy (&newterm,&oldterm,sizeof(struct termio));
#endif
  /* I don't know what you're trying to do with the below two statements...
   * on FreeBSD, this changes the VERASE and VWERASE chars */
  newterm.c_cc[4] = 1;
  newterm.c_cc[5] = 0;
  /* newterm.c_cflag = (B9600|CS8|CREAD); */
  newterm.c_lflag = 0;
  newterm.c_iflag = IGNBRK;
  newterm.c_oflag = 0;
#if defined(BSD)
  ioctl (file,TIOCSETAF,&newterm);
  read(file,&return_char,1);
  ioctl (file,TIOCSETAF,&oldterm);
#else
  ioctl (file,TCSETAF,&newterm);
  read(file,&return_char,1);
  ioctl (file,TCSETAF,&oldterm);
#endif
  close(file);
  return (return_char);
}















