/*

  PLOR Pluto Linux Offline Reader
  Copyright (C) 1996-1998  Davide Barbieri  
                         <paci@pluto.linux.it>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  */

#include <stdio.h>
#include <string.h> /* maybe strings.h in other OS */
#include <stdlib.h>

#include "pconfig.h"
#include "soupread.h"
#include "util.h"
#include "text.h"
#include "video.h"
#include "main.h"

char *buffer;
long buffer_size;

char msg_type='u';

int nfiles=0;
int j=0;
int mtmp=0;

union converter
{ 
  unsigned long l;
  unsigned char c[4];
} Conv;


void SOUP_update_areas(char *st, long lfs)
{
  int i=0;
  int ii=0;
  int lungtmp=-1;
  int iii;
  nfiles=0;
  j=0;
  do {
    
    for (; st[i] != '\t'; i++); 

    files[nfiles] = malloc(i+1);
    iii=0;
    
    for (ii=lungtmp+1; ii<i ; ii++){
      files[nfiles][iii]=st[ii];
      iii++;
    }

    files[nfiles][iii]='\0';
    lungtmp=i;
    i++;
    
    
    for (;st[i] !='\t'; i++);

    area_name[nfiles]= malloc(i-lungtmp+2);
    iii=0;
    
    for (ii=lungtmp+1; ii<i; ii++){
      area_name[nfiles][iii]=st[ii];
      iii++;
    }

    area_name[nfiles][iii]='\0';		
    lungtmp=i;
    i++;
    
    
    for (;st[i] !='\n'; i++);

    encoding[nfiles]= malloc(i-lungtmp+2);
    iii=0;
    
    for (ii=lungtmp+1; ii<i; ii++){
      encoding[nfiles][iii]=st[ii];
      iii++;
    }

    encoding[nfiles][iii]='\0';
    lungtmp=i;
    i++;
    nfiles++;
  } while ( lfs != i);
  Last_Conf=nfiles;

  for (i=0; i<nfiles; i++) strcat(files[i], ".MSG");
}


/* reads AREAS file, in which there are informations about
   newsgroup and mail conferences */
void SOUP_load_areas() 
{
  FILE *f;
  
  /* if the file doesn't exist or we can't open it ... */
  if ((f=fopen("AREAS","r"))==NULL){
    fprintf(stderr,"%s AREAS \n", err_msg[2]);
    exit(-1);
  }

  buffer_size=file_size(f);
  buffer=malloc(buffer_size);

  
  /* these lines will allocate memory for conference dinamically 
     but they didn't work; I will fix this */ 
  /*for (i=0;fgets(buffer,256,f);i++);
     
  files=malloc(100);
  area_name=calloc(i+1, sizeof(char*));
  encoding=calloc(i+1, sizeof(char*));*/ 
  

  fread(buffer,1,buffer_size,f);
  fclose(f);

  SOUP_update_areas(buffer, buffer_size); 

  free(buffer);
}
	

void SOUP_show_conf_list()
{	
  int i;

#ifndef PLAIN
  cls();
#endif

  for (i=0; i<nfiles; i++) { 
#ifndef PLAIN
    printf("%c %s\n", i+97, area_name[i]);
#else
    printf("%s\n", area_name[i]);
#endif
  }
  fflush(stdout);
  
  while((j = get_ch())){
   
    if (j>=97 && j<=(nfiles+97)){ /* choose the conference */
      Curr_Conf=j-97;
      SOUP_read_conf();
      SOUP_show_conf();
      continue;
    }
    if (j==72);  /* H for help */ 
    if (j==88)   /* X to quick-exit */
      exit(0);
    if (j==81)   /* Q to quit area */
      init_plor();
    else
      continue;
  }   
}


void SOUP_read_conf()
{
  FILE *fc;
  int row_tmp=0; int i=0; 
  /**char* file_name = files[Curr_Conf];**/
  char* p;         /* puntatore temporaneo per prendere      *
                    * il nome di chi ha scritto il messaggio */
  char temp[255];  /* vedi commento sopra */


  /*if (strncmp(file_name+7, ".MSG", 4))
    strcat(file_name, ".MSG");
    */
  if ((fc=fopen(files[Curr_Conf], "r"))==NULL) {
    printf("%s %s", err_msg[2], files[Curr_Conf]);
    exit(-1);
  }

  fseek(fc, 0, SEEK_SET);
  buffer = malloc(256); 
 
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * here we read conference file and take note of messages  *
   * this is the main important part of all                  *  
   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

  for(;fgets(buffer, 256, fc);){
    row_tmp++;

    if (*encoding[Curr_Conf]=='u')
      if ( strncmp(buffer, "#! rnews ", 9) == 0 ) {
	mesg_array[i].line=row_tmp;
	i++;
	continue;
      }
 

    if ( !strncmp(buffer+4, "From ", 5) && (*encoding[Curr_Conf]=='b') ) {
      mesg_array[i].line=row_tmp-1;
      i++;
      continue;
    } 

    /* we gets one line; sometimes happens that the 4 byte before
       "From " are split in two line, so we must return 2 line up... 
       not clear? even for me... and this is quite buggy and
       an ugly patch... sorry for the moment...*/
    if ( (!strncmp(buffer+1, "From ", 5) || 
          !strncmp(buffer+2, "From ", 5) || 
          !strncmp(buffer+3, "From ", 5)) &&
         (*encoding[Curr_Conf]=='b') ) {
	  mesg_array[i].line=row_tmp-2;
	  i++;
	  continue;
	}
    

    if ( strncmp(buffer, "From: ", 6)==0 ){

      /* l'indirizzo e`: */
      mesg_array[i-1].email=malloc(strcspn(buffer,"<(")+1);
      strncpy(mesg_array[i-1].email, buffer, strcspn(buffer,"<("));

      /* Is there a name between <> or () ? */
      p=strchr(buffer,'<');
  
      if (p) {
	strcpy (temp,p+1);
	p=strrchr(temp,'>');
	
	/* We need at least 4 chars in the name */
	if (p < temp+4)
	  strcpy( temp, buffer+6);
	else
	  *p='\0';
      }
      else {                         /* if(p) */
	p=strchr(buffer,'(');
	if (p) {
	  strcpy (temp,p+1);
	  p=strrchr(temp,')');

	  /* We need at least 4 chars in the name */
	  if (p < temp+4)
	    strcpy( temp, buffer+6);
	  else
	    *p='\0';
	}
	else 
	  /* Nope, just use the address as name */
	  strcpy(temp,buffer+6);
      }

      strncpy (mesg_array[i-1].from,temp,15);
      mesg_array[i-1].from[15]='\0';

      continue;
    }
    
    if (strncmp("Subject: ", buffer, 9)==0) {
      strcpy(mesg_array[i-1].subj, buffer+9);
      mesg_array[i-1].subj[59]='\0'; /* terminiamo qui senno non ci sta */
    
      /* some email has no subject */
      if (!mesg_array[i-1].subj)
        strcpy(mesg_array[i-1].subj,"(no subject)");

      continue;
    }

    if (strncmp("Message-ID: ", buffer, 12)==0)
      strcpy(mesg_array[i-1].id, buffer+12);

  } /* end for */

  Last_Mesg=i; /* store number of messages */
  fclose(fc);
}


void SOUP_show_conf() {
  int i;
  /* ora come ora bisogna dichiararlo globale 
     int mtmp=0; */

#ifndef PLAIN
  cls();
#endif

  for (j=0; mtmp<Last_Mesg && j<(ROWS-1); j++){
    locate(1, j+1);
    printf("%c %s", j+97, mesg_array[mtmp].from);
    locate(19,j+1);
    printf(" %s", mesg_array[mtmp].subj);
    mtmp++;
  }


  /* show tool bar */
  locate(1,j+1); 

  cyan();
  if (Last_Mesg>j) 
    printf("Press message letter, W post, > next msg, < prev msg, Q quit");
  else 
    printf("Press message letter, W post or Q to quit");
  white();
  fflush(stdout);
  

  while ((i = get_ch())){ /* choose the news o email */
    
    if (i==81) {                /* Q to quit */
      mtmp=0; /* bisogna rimetterlo a zero per visualizzare i msg */
      SOUP_show_conf_list();
      continue;
    }

    if (i==87){ /* W Write a post */
      SOUP_reply(-1, 'u', -1);
      SOUP_show_conf_list();
    }

    if (i==88) /* X quick exit */
      exit(0);

    if ( i>=97 && i<=(j+97) ){  /* select message */
      Curr_Mesg=(i-96)+mtmp-j;
      mtmp-=j;
      SOUP_read_msg(Curr_Mesg);
      SOUP_show_conf();
    }

    if (i==62){                 /* show next articles */
      if (mtmp==Last_Mesg) continue;
      else{
	SOUP_show_conf();
	break;
      }
    }
    if (i==60){                 /* show previous articles */
      if (mtmp-(j+ROWS-1)<0) continue;
      else{
	mtmp-=(j+ROWS-1);
	SOUP_show_conf();
	break;
      }
    }
    if (i==83){
      Curr_Mesg=(i-96)+mtmp-j;
      SOUP_read_msg(Curr_Mesg);
    }
    if (i==32);
    else
      continue;
  } /* end while */
} /* end function */		


void SOUP_save_msg(int mesg, int loop){
  FILE *fs, *fc;
  int i;
  int nbytes=0;             /* lenght of msg in bytes */
  int byte_count=0;         /* scan count byte of msg */
  char strtmp[10];
  char type=*encoding[Curr_Conf];
  char save_file_name[255]; /* let them save a file with 255 chars */

  if ((fc=fopen(files[Curr_Conf], "r"))==NULL) {
    printf("%s %s", err_msg[2], files[Curr_Conf]);
    exit(-1);
  }
  fseek(fc, 0L, SEEK_SET);

  if (loop!=2) {
    locate(1,ROWS-1);
  
    printf("Save file name: ");
    fflush(stdout);

    read_line(save_file_name);

    if ((fs=fopen(save_file_name,"a"))==NULL)  exit(-1);
  }

  if (loop==1) loop=2;

  for (i=0; i < (mesg_array[mesg-1].line); i++)  fgets(buffer, 256, fc);
  
  if (type=='u'){
    /* get length of msg */
    strncpy(strtmp, buffer+9, 10);
    nbytes=atoi(strtmp);
  }

  if (type=='b'){
    Conv.c[3] = fgetc( fc );
    Conv.c[2] = fgetc( fc );
    Conv.c[1] = fgetc( fc );
    Conv.c[0] = fgetc( fc );
    nbytes=Conv.l;
  }

  /* MORE ROUTINE */
  for (i=0; byte_count < nbytes; i++){
    fgets(buffer, 256, fc);
    byte_count+=strlen(buffer);
    fputs(buffer, fs);
  }

  if (loop==2 && mesg<Last_Mesg) SOUP_save_msg(mesg+1, 2); 

  fclose(fs);
}


void SOUP_read_msg(int mesg)
{
  FILE *fc;
  int i, tmp;
  int nbytes=0;           /* lenght of msg in bytes */
  int byte_count=0;       /* scan count byte of msg */
  char strtmp[10];
  char type=*encoding[Curr_Conf];
  cls();                  /* clear screen           */

  if ((fc=fopen(files[Curr_Conf], "r"))==NULL) {
    printf("%s %s", err_msg[2], files[Curr_Conf]);
    exit(-1);
  }

  fseek(fc, 0L, SEEK_SET);
  for (i=0; i < (mesg_array[mesg-1].line); i++) fgets(buffer, 256, fc);
  
  if (type=='u'){
    /* get length of msg */
    strncpy(strtmp, buffer+9, 10); 
    nbytes=atoi(strtmp);  
  }
  
  if (type=='b'){
    Conv.c[3] = fgetc( fc );
    Conv.c[2] = fgetc( fc );
    Conv.c[1] = fgetc( fc );
    Conv.c[0] = fgetc( fc );
    nbytes=Conv.l;
  }

  
  /* DISPLAY MESSAGES */

  /* MORE ROUTINE */
  for (i=0; byte_count < nbytes ; i++){
    if (!plain && i==(ROWS)){
      locate(0,ROWS); 
      cyan();
      printf("-- N)ext, P)rev, F post reply, R mail reply, S)ave, Q back--%i bytes of %i", byte_count, nbytes);
      white();
      fflush(stdout);
      tmp=SOUP_browser(1); /* call SOUP_browser */
      if (tmp==1) byte_count=0;
      cls();
      i=0;
      continue;
    }
    
    fgets(buffer, 256, fc);
    byte_count+=strlen(buffer);
    
    if (!plain) locate(0,i);
  
    printf("%s", buffer);
  } 

  if (!plain){
    locate(0,i);
    cyan();
    printf("[end of article] press p, n or Q");fflush(stdout);
    white();
    SOUP_browser(0);
    
  }
  /* END DISPLAY MESSAGES */
}

int SOUP_browser(int SPACE)
{
  int i;
  /* BEGIN BROWSE MESSAGES */
  
  while ((i = get_ch())){
    switch (i){
    case 70: /* F reply */
      white();
      SOUP_reply(0, 'u', Curr_Mesg);
      return(1);

    case 83: /* S save */
      SOUP_save_msg(Curr_Mesg, 0);
      break;
      
    case 81: /* Q - quit */
      SOUP_read_conf(Curr_Conf);
      SOUP_show_conf();
      break; /* pleonastic */
      
    case 110: /* n - skip to the next article */
      if (Curr_Mesg==Last_Mesg){
	printf("No more messages"); fflush(stdout);
	break;
      }
      Curr_Mesg++;
      SOUP_read_msg(Curr_Mesg);	
      
    case 112: /* p - back to previous message */
      if ((Curr_Mesg-1)==0){
	printf("No previous message"); fflush(stdout);
	break;
      }
      Curr_Mesg--;
      SOUP_read_msg(Curr_Mesg);
      break;
      
      /* more message if SPACE=1 or continue if SPACE=0 */	
    case 32:  
      if (SPACE==0) continue;
      else return(0);
      
    default:
      continue;
    } /* end switch */
  } /* end while */
  
  return(0);
}























