/* 
  Main program
  PLOR Pluto Linux Offline Reader
  Copyright (C) 1996-1998 Davide Barbieri <paci@pluto.linux.it>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>

/* will be included when we will have locale support
#include <locale.h>
#include <nl_types.h>
*/

#include "main.h"
#include "text.h"
#include "video.h"
#include "pconfig.h"
#include "qwkread.h"
#include "soupread.h"


int plain = FALSE; /* plain output or not? */

int Curr_Mesg=1;
int Last_Mesg=1;
int Curr_Conf=1;
int Last_Conf=1;

int ROWS=25;

void startup_msg()
{
  printf("\nDavide Barbieri");
  printf("presents: \n\n%s %s\n\n", PROGNAME, VERSION);
  printf("The last but not least soup & qwk reader!\n");
  printf("This program is copyright by the authors (C) 1996-1997\n\n");
  printf("This is FREE SOFTWARE. NO WARRANTY IS GRANTED FOR THIS SOFTWARE");
  printf("\n\nPlease report bugs, corrections and suggestions\n");
  printf("to paci@pluto.linux.it\n\n\n");
}


void init_plor()
{ 
  char ch;
  int i=0;
  
  ROWS=rows();
  
  
  /* for locale support, in the future (i have no gencat) 
     static nl_catd  catfd = 0;

     setlocale(LC_MESSAGES, "");

     catfd = catopen("foo.cat", MCLoadBySet);
     if (catfd == -1)
       printf("Failed to open the message catalog");
  */

  /* print main menu */
  cls();
  startup_msg();

  for (; i<5; i++) printf("%i) %s\n", i+1, main_menu[i]);
 
  while ((ch=get_ch())){
    
    switch (ch){
    case '1':
      QWK_load_control();
      QWK_show_conf();
      break;
    case '2':
      SOUP_load_areas();
      SOUP_show_conf_list();
      break;
    case '3':
      printf("Help on Line, not yet supported!!!");
      continue;
    case '4':
      printf("Replies not yet implemented!!!");
      continue;
    case '5':
    case 'q':
    case 'Q':  
    case 'X':
      cls();
      printf("\n Exiting ...\n");
      SOUP_pack_replies();
      printf("\n thanks for using PLOR\n\n");
      exit(0);
      break;
    default:
      printf("vado giu`");
      dn(1);
      continue;
    } /* end switch */
  } /* end while */
}


int main(int argc, char *argv[])
{
  int c;
  
  white();
  
  /* getopt */
  while ( (c = getopt(argc, argv, "hpqs:c:m:v")) ) {
    if (c == -1)
      break;
    switch (c) {
    case 'h':
      startup_msg();
      printf("\noptions:\n\n-h show this help\n");
      printf("-p plain output\n");
      printf("-s select soup mode\n");
      printf("-q select qwk mode (not yet implemented)\n");
      printf("-c <n> select conference number n\n");
      printf("-m <n> select message number n\n");
      printf("-v print version number\n");
      printf("\n");      exit(0);
    
    case 'p':
      plain = TRUE;
      break;
    
    case 's':
      SOUP_load_areas();
      SOUP_read_conf();
      break;
      
    case 'c':   
      Curr_Conf = atoi(optarg) - 1;
      break;
    
    case 'm':
      SOUP_read_msg(atoi(optarg));
      break;
      
    case 'q':
      QWK_load_control();
      QWK_read_conf(Curr_Conf);
      break;

    case 'v':
      printf("%s %s\n", PROGNAME, VERSION);
      return(0);

    case ':':
      exit(0);
    }
  }
  
  if (!plain) {

    /*startup_msg();*/
      
    init_plor();

  }

  return(0);
}




