########################################################################################################
###############################      Plans config file    ##############################################
########################################################################################################
# This file stores installation-specific settings for the plans calendar.  You may need to change them 
# to match how your server or site is set up.
#
# Each time plans runs, it looks for this file in the same directory 
# plans.cgi is in.  If found, this file is compiled with the rest of 
# plans.  The following statements are actual perl code. 

########################################################################################################
###############################          Language         ##############################################
########################################################################################################
# All user-facing text is stored in a table.  When Plans runs, it sources $options{language_file}, which 
# fills the table with the appropriate stuff.
$options{language_file} = "us_english.pl";

########################################################################################################
###############################          Timezones         #############################################
########################################################################################################
# Each calendar in Plans can have its own timezone.  While this is handy for some folks, 
# it causes confusion if timezones are changed by accident.
# Keep this switch set at 1 to force all calendars to use the main calendar's timezone.
$options{force_single_timezone} = 1;

########################################################################################################
###############################          Event Times         ###########################################
########################################################################################################
# New events in Plans are all-day events by default
# You can set this switch to 0 to make new events have an event time by default
$options{new_events_all_day} = 1;

########################################################################################################
###############################            Password          ###########################################
########################################################################################################
# If you're on an intranet or private server, you may wish to disable 
# passwords in Plans entirely.  You can do so by setting this option to 1.
$options{disable_passwords} = 0;


########################################################################################################
###############################      Selecting Multiple Calendars     ##################################
########################################################################################################
# Each event in Plans is associated with a calendar.
# If this switch is 1, all calendars will always appear in the calendar controls dropdown.
#
# If this switch is 0, each calendar gets to choose what other calendars will be in the dropdown
# when it's the active calendar.  This can be used to manage a large hierarchy of calendars, but it
# requires more oversight, especially when creating new calendars.
 
$options{all_calendars_selectable} = 1;

# If this variable is 1, new calendars will automatically be added to all existing 
# calendars' drop-down selections at creation time.
# this option has no visible effect if $options{all_calendars_selectable} = 1.
$options{new_calendars_automatically_selectable} = 1;



########################################################################################################
###############################       Multi-calendar events     ########################################
########################################################################################################
# Each event in Plans is associated with one calendar by default.
# However, individual events can be associated with multiple calendars
# (This is different from Plans' ability to merge entire calendars)
#
# 0 = single calendar (events allowed to be under only one calendar)
#
# 1 = multi-calendar, single password (events can be under multiple calendars,
#     but only the password from the original calendar can be used to modify the event)
#
# 2 = multi-calendar, multi-password (events can be under multiple calendars,
#     and any of their passwords can be used to modify the event.)
 
$options{multi_calendar_event_mode} = 0;

########################################################################################################
###############################          View Types         ############################################
########################################################################################################
# Here you can turn on of off Plans' various view types.  
# This affects the "display" menu in the calendar controls.
# 1 to enable, 0 to disable.
$options{display_types}[0] = 1;  # calendar view
$options{display_types}[1] = 1;  # list view
$options{display_types}[2] = 0;  # daily view (event details) not implemented yet!





########################################################################################################
###############################        Data storage        #############################################
########################################################################################################
# You can store calendar data in flat files or a database (like mySQL).
# The default storage mode is plain text files.
# you can switch modes at any time--plans will convert your existing data.
# 0 = flat text files
# 1 = sql
$options{data_storage_mode} = 0;

################################   Flat-file mode  (mode 0)   ##########################################
########################################################################################################

# unless you specify the absolute path, these files are assumed 
# to be in the same directory as plans.cgi

$options{calendars_file} = "calendars.xml";           # custom settings for the calendar(s) generated by plans.
$options{events_file} = "events.xml";                 # event data for all calendars.
$options{new_calendars_file} = "new_calendars.xml";   # stores new (not yet approved) calendars.

#################################    SQL DBI mode (mode 1)     #########################################
# Perl's database abstraction layer (DBI) can talk to most SQL database types.
########################################################################################################
if ($options{data_storage_mode}==1) {
  $dbh;                                       # define global database handle
  require DBD::mysql;                         # Here, you specify what database type you'll be using.
  $options{db_name} = "plans_demo1";          # And the name of the database (you have to create it on your own first)
  $options{db_hostname} = "mysql-plans-demo1.planscalendar.com";         # And the database hostname
  $options{db_username} = "plans_demo1";      # And the username you'll use to connect
  $options{db_password_file} = "../plans_demo_mysql.pwd";        # Put the DB password in this file.
                                              # Make sure this file is *not* publically
                                              # readable (chmod 400 on unix)
                                          
                                           
                                              # You don't have to create these tables.
                                              # Plans will do it for you.
  $options{calendars_table} = "calendars";               # Table for storing calendar settings.
  $options{events_table} = "events";                     # Table for storing event data.
  $options{new_calendars_table} = "new_calendars";       # Table for storing event data.
  
  
  
  # open the password file
  open (FH, "$options{db_password_file}") || {$debug_info.= "unable to open file $options{db_password_file}\n"};
  flock FH,2;
  $options{mysql_password}=<FH>;
  close FH;
  chomp $options{mysql_password};
  
  # connect to the db host
  if (!($dbh = DBI->connect("DBI:mysql:database=$options{db_name};host=$options{db_hostname}","$options{db_username}","$options{mysql_password}"))) 
  {
    $fatal_error=1;
    $error_info.= "DB connect error! $DBI::errstr";
    return 1;
  }
}


########################################################################################################
###############################      File Locations        #############################################
########################################################################################################
# This is the default file structure for plans:
#
# plans/
#       plans.cgi
#       plans.config
#       events.xml
#       calendars.xml
#       theme/
#             plans.template
#             plans.css
#             icons/
#             graphics/
#
# If you move the theme directory to a different location for some reason 
# (for instance, if your server does't allow static files be served from 
# the same directory (or subdirectories) as scripts, uncomment the variable 
# below and set it accordingly.  You'll also need to change the default 
# template file in the next section.
#$theme_url  = "http://www.yoursite.com/theme_directory";      # note there is no end slash!

########################################################################################################
###############################    Default Template    #################################################
########################################################################################################
# All calendars use the same default template file, specified below.
#
# Calendars can have their own custom template files, which override the default file.
# this custom template file must be an URL (plans will fetch it across the network, even 
# if it resides on the same server).  This increases security and allows template files to 
# come from other websites.
#
# If a calendar doesn't specify a custom template file, or plans is unable to fetch the custom 
# template file, it will use the default template file below.  
                                                              
$options{default_template_path} = "theme/plans.template";     # On windows, the you might have to change this to something:
                                                           # like: "C:/path/to/plans/theme/plans.template"
                                                           # IMPORTANT -- this is not an URL.  It's a filesystem path.


########################################################################################################
###############################            Email           #############################################
########################################################################################################
# Plans can send email reminders to visitors
# If this is turned on, an email reminder link will appear in the event details.
# If a user clicks on it, a record will be added to $options{email_reminders_datafile}
# This file is read by email_reminders.cgi, which is what actually sends the email.
#
# email_reminders.cgi does not run automatically when Plans runs.  You have to run it 
# as a cron job (unix) or a scheduled task (windows).  You can also run email_reminders.cgi 
# manually from the command line, or by pointing your browser at it.

$options{email_mode} = 1;  # 0 = off
                           # 1 = sendmail (unix)
                           # 2 = STMP (windows or unix)
                            
if ($options{email_mode} == 1)
{
  $options{sendmail_location} = "/usr/sbin/sendmail";
}
elsif ($options{email_mode} == 2)
{
  require Net::SMTP;
  $options{mail_server}="your.smtp.server.address";
  $smtp = Net::SMTP->new($options{mail_server});
}

$options{reply_address} = "address\@domain.com";   # used for the "from" and "reply-to" fields of reminder emails
$options{email_reminders_datafile} = "email_reminders.xml";         # xml file where email reminder data is kept.


$options{new_calendar_request_notify} = "calendar_admin\@domain.com";   # send an email here when someone requests a new calendar
      
      
########################################################################################################
###############################            Tabs            #############################################
########################################################################################################
# You can customize the text shown on the tabs.
# If you set a tab's text to an empty string (""),
# that tab will disappear entirely.

# If you want to remove all the tabs, an easier 
# way is to remove the ###tab menu stuff### 
# tag from the plans.template file.

@tab_text = ("Calendars", 
             "Add / Edit Events", 
             "Calendar Settings");
             
########################################################################################################
############################         Right-click menus         #########################################
########################################################################################################
# If you right-click on a day or event, you get a drop-down menu
# with options like "add event on this day". 

# To disable these menus, set the following variable to 0.

$options{right_click_menus_enabled} = 1;
             
########################################################################################################
#############################     Event Background Colors    ###########################################
########################################################################################################
# set this to 1 to have the descriptions in the 
# second column appear on the colors in the dropdown menu.
$options{show_event_background_color_descriptions} = 0;

# You can change these or add more.
$event_background_colors = <<p1;
#ffffff   White        
#eeeeee   Off-white    
#66cc66   Dark Green
#99ffcc   Sea Green
#ccffcc   Pastel Green        
#ccffff   Blue         
#99ccff   Darker blue  
#addadd
#ffaa99   Red-orange
#ffcc99   Orange       
#ffddbb   Peach
#ffccff   Pink         
#eeddff   Light Pink
#efe7de   Tan  
#fffbba   Light orange 
#ffffcc   Yellow       
#daddad
#cabcab
p1


# Make sure there are no spaces or tab characters 
# after the "p1", on the same line.  This is a 
# source of errors for those who aren't familiar with perl :)

########################################################################################################
#############################         Default Details        ###########################################
#############################       (for new calendars)      ###########################################
########################################################################################################
# You may want some boilerplate text in the "details" section of a 
# new calendar.

$new_calendar_default_details = "You must include a contact email address for the calendar to be approved.";


########################################################################################################
################################        Event Icons        #############################################
########################################################################################################
# If you want to add your own icons, 
# you'll need:
# -  three copies of your icon in the $theme_url/icons/ directory
#    - a 50 x 50 version, named my_icon_50x50.gif
#    - a 32 x 32 version, named my_icon_32x32.gif
#    - a 16 x 16 version, named my_icon_16x16.gif
# - a new entry in the menu structure below 
#
# The icon menu structure looks like HTML, but it's not really.  It's an XML
# format that is translated by plans into html.  Most browsers display nested submenus 
# in "flattened" groups, which looks ok.  Someday, browsers will support real 
# nested menus.  It's possible to use javascript to fake this, but it's flaky 
# and has problems with browser form elements.
# see http://www.brainjar.com/css/positioning/default5.asp for technical details.


$event_icons_menu =<<p1;
<menuitem value="blank">Blank (no icon)</menuitem>
<menu name="General Icons">
 <menuitem value="clipboard">Clipboard &amp; pencil</menuitem>
 <menuitem value="pencil">Pencil</menuitem>
 <menuitem value="bullet_point">Bullet point</menuitem>
 <menuitem value="smiley">Smiley</menuitem>
 <menuitem value="dollar_sign">Dollar Sign</menuitem>
 <menuitem value="exclamation">Exclamation point</menuitem>
 <menuitem value="clock">Clock</menuitem>
 <menuitem value="clock2">Clock</menuitem>
 <menuitem value="us_flag">Stars &amp; Stripes</menuitem>
 <menuitem value="news">News</menuitem>
 <menuitem value="1st_aid">First Aid</menuitem>
 <menuitem value="popcorn">Popcorn</menuitem>
 <menuitem value="globe">Globe</menuitem>
 <menuitem value="envelope">Envelope</menuitem>
 <menuitem value="lightbulb">Light Bulb</menuitem>
 <menuitem value="paperclip">Paper Clip</menuitem>
 <menuitem value="plane">Plane</menuitem>
 <menuitem value="check">Check mark</menuitem>
 <menuitem value="paintpalette">Paint Palette</menuitem>
 <menuitem value="tux">Tux</menuitem>
</menu>
<menu name="Outdoor Icons">
 <menuitem value="plane">Aeroplane</menuitem>
 <menuitem value="globe">Globe</menuitem>
 <menuitem value="bike">Bike</menuitem>
 <menuitem value="fire">Campfire</menuitem>
 <menuitem value="axe">Axe</menuitem>
 <menuitem value="canoe">Canoe</menuitem>
 <menuitem value="compass">Compass</menuitem>
 <menuitem value="fish">Fish</menuitem>
 <menuitem value="starfish">Starfish</menuitem>
 <menuitem value="e_frame_pack">Pack (ext. frame)</menuitem>
 <menuitem value="i_frame_pack">Pack (int. frame)</menuitem>
 <menuitem value="snowflake">Snowflake</menuitem>
 <menuitem value="tent">Tent</menuitem>
</menu>
<menu name="Garden Icons">
 <menuitem value="apple">Apple</menuitem>
 <menuitem value="bellpepper">Bell Pepper</menuitem>
 <menuitem value="peach">Peach</menuitem>
 <menuitem value="grapes">Grapes</menuitem>
 <menuitem value="pumpkin">Pumpkin</menuitem>
 <menuitem value="flower">Flower</menuitem>
 <menuitem value="flowerpot">Flowerpot</menuitem>
</menu>
<menu name="Religious &amp; Holiday Icons">
  <menuitem value="heart">Heart</menuitem>
  <menuitem value="easteregg">Easter Egg</menuitem>
  <menuitem value="turkey">Turkey</menuitem>
  <menuitem value="wreath">Wreath</menuitem>
  <menuitem value="star_david">Star of David</menuitem>
  <menuitem value="church">Church</menuitem>
</menu>
p1
# Again, be careful to avoid putting any characters 
# (normal or whitespace) after the "p1", on the same line.  This is a 
# source of errors for those who aren't familiar with perl :)

########################################################################################################
################################     Unit Number Icons     #############################################
########################################################################################################
# Plans was originally devloped as a calendar for a scout troop.  This 
# feature is a holdover from those days.  For it to work correctly, 
# the graphics for unit number icons must be present in the $graphics_url.

$options{unit_number_icons} = 0;

return 1;
