/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: rcsvfile.h,v 1.5 2000/04/24 16:11:53 mw Exp $
*/


#ifndef _RCSVFILE_H
#define _RCSVFILE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <qfile.h>
#include <qlist.h>
#include <qobject.h>

#include "addrrecord.h"

typedef struct _AInfo
{
    int category;
    bool secret;
} AInfo;


class ReadCSVFile : public QObject
{
  Q_OBJECT

public:
    ReadCSVFile(QFile &f, bool *b=0, QString *qsAppInfoFile=0);
    ~ReadCSVFile();

    time_t getCreateDate();
    time_t getModifyDate();
    time_t getBackupDate();

    const char *getName();
    int   getAppInfo(AddressAppInfo *aaip);
    int   getNEntries();
    int   readRecord(int i, Address *ap, int *iattrs, int *cat);
    
private slots:

private:
    bool   *bError;
    char   *name;
    int    nentries;

    // CSV data:
    AddressAppInfo aai;
    QList<Address> *alist;
    QList<AInfo> *ilist;

    // methods:
    char * popCSV(char **p);
};

#endif
