/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: notedlg.cpp,v 1.6 2000/04/24 16:11:52 mw Exp $
*/

#include "common.h"
#include "notedlg.h"

#include "notedlg.moc"


NoteDlg::NoteDlg(QWidget *parent, char *name, 
                 const char *note) 
	: QDialog(parent,name,TRUE,WStyle_Customize | WStyle_NormalBorder)
{
  setCaption("Show note");

  mlined1 = new QMultiLineEdit(this, "mlined1");
  mlined1->setGeometry(lMargin, tMargin, 340, 240);
  mlined1->setReadOnly(TRUE);
  if (note && *note)
    mlined1->setText(note);
	
  pbCancel = new QPushButton(this, "pbCancel");
  pbCancel->setText("Close");
  pbCancel->resize(pbCancel->sizeHint());
  pbCancel->setGeometry(lMargin, tMargin+mlined1->height()+tMargin,
                        pbCancel->width(), pbCancel->height());
  connect(pbCancel, SIGNAL(clicked()), SLOT(reject()));

  resize(lMargin+mlined1->width()+rMargin, 
         tMargin+mlined1->height()+tMargin+pbCancel->height()+bMargin);

  setFixedSize(width(), height());
}


NoteDlg::NoteDlg()
  : QDialog(0,"",TRUE,WStyle_Customize | WStyle_NormalBorder)
{
  ;
}


NoteDlg::~NoteDlg()
{
  ;
}



