/* Copyright (C) 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id:$
*/

#ifndef _CATNAMEDLG_H
#define _CATNAMEDLG_H

#include <qbttngrp.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbt.h>

class CatNameDlg : public QDialog
{
  Q_OBJECT

public:
  CatNameDlg(QWidget *parent, const char *name, char *catname, 
             QString *pqsCat, const char*font="fixed", int points=10);
    ~CatNameDlg();

private slots:
    void setup();
    void apply();
    void accept();
    void cancel();

private:
    QLineEdit   *leCatName;
    QPushButton *pbCancel;
    QPushButton *pbOK;
    QString     *pqsCat_m;
};

#endif
