/* Copyright (C) 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id:$
*/

#include "common.h"
#include "catnamedlg.h"

#include "catnamedlg.moc"

CatNameDlg::CatNameDlg(QWidget *parent, const char *name, char *catname,
                       QString *pqsCat, const char *font, int points)
	   : QDialog(parent,name,TRUE,WStyle_Customize | WStyle_NormalBorder)
{
  setCaption("Enter category name");
  QFont f(font, points);

  pqsCat_m = pqsCat;
  
  pbOK = new QPushButton(this, "pbOK");
  pbOK->setText("OK");

  pbCancel = new QPushButton(this, "pbCancel");
  pbCancel->setText("Cancel");

  connect(pbOK,     SIGNAL(clicked()), SLOT(accept()));
  connect(pbCancel, SIGNAL(clicked()), SLOT(reject()));

  QSize sz1, sz2;
  sz1 = pbOK    ->sizeHint();
  sz2 = pbCancel->sizeHint();

  int h1, h2, w1, w2, w, h;
  h1 = sz1.height();
  h2 = sz2.height();
  w1 = sz1.width();
  w2 = sz2.width();
  h = (h1 > h2) ? h1 : h2;
  w = (w1 > w2) ? w1 : w2;
  QSize sz(w, h);
  pbOK    ->resize(sz);
  pbCancel->resize(sz);

  leCatName = new QLineEdit(this, "leCatName");
  leCatName->setFont(f);
  leCatName->setMaxLength(15);
  leCatName->setText(catname);
  leCatName->selectAll();
  leCatName->setFocus();

  sz1 = leCatName->sizeHint();

  w1 = lMargin + pbOK->width() + bttnMargin + pbCancel->width() + rMargin;
  w2 = sz1.width();
  w = (w1 > w2) ? w1 : w2;
  leCatName->resize(w,   leCatName->height())  ;

  leCatName->move(lMargin, tMargin);
  pbOK     ->move(lMargin, leCatName->y() + bttnMargin + leCatName->height());
  pbCancel ->move(leCatName->x() + leCatName->width() - pbCancel->width(),
		 leCatName->y() + bttnMargin + leCatName->height());
  
  resize(pbCancel->x() + pbCancel->width() + lMargin,
         pbOK->y() + pbOK->height() + bMargin);
  setFixedSize(width(), height());
  
}

void CatNameDlg::accept()
{
  *pqsCat_m = leCatName->text();
  QDialog::accept();  
}

CatNameDlg::~CatNameDlg()
{
  ;
}

void CatNameDlg::apply()
{

}

void CatNameDlg::cancel()
{

}

void CatNameDlg::setup()
{
}
