/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: addrrecord.h,v 1.8 2000/04/24 16:11:52 mw Exp $
*/


#ifndef ADDRRECORD_H
#define ADDRRECORD_H

#include "address.h"

#include <qobject.h>

class AddressRecord : public QObject
{
    Q_OBJECT

public:
    AddressRecord();
    AddressRecord(const Address *, int iCat=0, bool bMod=FALSE);
    ~AddressRecord();

    void cloneAddress(Address *a);
    void putShowPhone(int);
    void putFN      (const char *);
    void putGN      (const char *);
    void putTitle   (const char *);
    void putCompany (const char *);
    void putPhone1  (const char*);
    void putPhone2  (const char *);
    void putPhone3  (const char *);
    void putPhone4  (const char *);
    void putPhone5  (const char *);
    void putAddress (const char *);
    void putZIP     (const char *);
    void putTown    (const char *);
    void putState   (const char *);
    void putCountry (const char *);
    void putDefined1(const char *);
    void putDefined2(const char *);
    void putDefined3(const char *);
    void putDefined4(const char *);
    void putNote    (const char *);
    void putPrivate (bool);
    void putModified(bool);
    void setCat     (int);
    void putPhoneLabelIdx0(int);
    void putPhoneLabelIdx1(int);
    void putPhoneLabelIdx2(int);
    void putPhoneLabelIdx3(int);
    void putPhoneLabelIdx4(int);
    
    int         getShowPhone();
    const char *getFN      ();
    const char *getGN      ();
    const char *getTitle   ();
    const char *getCompany ();
    const char *getPhone   (int);
    const char *getPhone1  ();
    const char *getPhone2  ();
    const char *getPhone3  ();
    const char *getPhone4  ();
    const char *getPhone5  ();
    const char *getAddress ();
    const char *getZIP     ();
    const char *getTown    ();
    const char *getState   ();
    const char *getCountry ();
    const char *getDefined (int);
    const char *getDefined1();
    const char *getDefined2();
    const char *getDefined3();
    const char *getDefined4();
    const char *getNote    ();
    bool        getPrivate ();
    bool        getModified();
    int         getCat();
    int         getPhoneLabelIdx0();
    int         getPhoneLabelIdx1();
    int         getPhoneLabelIdx2();
    int         getPhoneLabelIdx3();
    int         getPhoneLabelIdx4();
    int         getPhoneLabelIdx(int p);
private:
    Address Addr;
    bool    bPrivate;
    int     iCat;
    bool    bModified;
};

#endif

