/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: addrdlg.h,v 1.5 2000/04/24 16:11:52 mw Exp $
*/

#ifndef _ADDRDLG_H
#define _ADDRDLG_H

#include "address.h"
#include "addrrecord.h"

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlined.h>
#include <qmlined.h>
#include <qradiobt.h>
#include <qtabdlg.h>

enum {
   DlgWidth = 400,
   DlgHeight= 400
};

class AddressDlg : public QDialog
{
  Q_OBJECT

public:
    AddressDlg(QWidget *parent, const char *name, AddressRecord *a, 
               AddressAppInfo *pAppInfo=0, bool *b=0, 
               const char*font="fixed", int points=10);
    ~AddressDlg();

private slots:
    void setup();
    void apply();
    void cancel();

private:
    AddressRecord *A;
    bool          *bC;
    
    // Page one: Name
    QLineEdit *leFN;
    QLineEdit *leGN;
    QLineEdit *leTitle;
    QLineEdit *leCompany;

    QComboBox *cbPhone1;
    QComboBox *cbPhone2;
    QComboBox *cbPhone3;
    QComboBox *cbPhone4;
    QComboBox *cbPhone5;

    QButtonGroup *rb;
    QRadioButton *rbPhone1;
    QRadioButton *rbPhone2;
    QRadioButton *rbPhone3;
    QRadioButton *rbPhone4;
    QRadioButton *rbPhone5;
    
    QLineEdit *lePhone1;
    QLineEdit *lePhone2;
    QLineEdit *lePhone3;
    QLineEdit *lePhone4;
    QLineEdit *lePhone5;

    QCheckBox *cbPrivate;

    QComboBox *cbCat;
    
    // Page two: Addresses   
    QMultiLineEdit *mlAddress;
    QLineEdit *leZIP;
    QLineEdit *leTown;
    QLineEdit *leState;
    QLineEdit *leCountry;
    
    QLineEdit *leDefined1;
    QLineEdit *leDefined2;
    QLineEdit *leDefined3;
    QLineEdit *leDefined4;

    // Page three: Note
    QMultiLineEdit *mlNote;
};

#endif
