/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: addrdlg.cpp,v 1.9 2000/04/24 16:11:52 mw Exp $
*/

#include "addrdlg.h"
#include "common.h"

#include <qglist.h>
#include <qkeycode.h>

#include "addrdlg.moc"

AddressDlg::AddressDlg(QWidget *parent, const char *name, 
                       AddressRecord *a, AddressAppInfo *pAppInfo, 
                       bool *bCancel, const char *font, int points)
  : QDialog (parent, name, FALSE)
{
  bool bUS=FALSE;
  int i;

  if (stricmp(pAppInfo->category.name[0], "Unfiled")==0)
    bUS = TRUE;

  A = a;
  bC = bCancel;

  QFont f(font, points);

  QTabDialog *tab = new QTabDialog(0, "top-level dialog", TRUE);
  tab->setCaption("Edit address");
  tab->resize(DlgWidth, DlgHeight);
  
  // page one
  QWidget *w       = new QWidget(tab, "Edit address");

  QLabel *lFN      = new QLabel(w);
  QLabel *lGN      = new QLabel(w);
  QLabel *lTitle   = new QLabel(w);
  QLabel *lCompany = new QLabel(w);

  lFN->setText(pAppInfo->labels[0]);
  lGN->setText(pAppInfo->labels[1]);
  lTitle->setText(pAppInfo->labels[13]);
  lCompany->setText(pAppInfo->labels[2]);

  lFN     ->setAlignment(AlignRight);
  lGN     ->setAlignment(AlignRight);
  lTitle  ->setAlignment(AlignRight);
  lCompany->setAlignment(AlignRight);

  QSize sz1, sz2, sz3, sz4;
  sz1 = lFN->sizeHint();
  sz2 = lGN->sizeHint();
  sz3 = lTitle->sizeHint();
  sz4 = lCompany->sizeHint();
  
  int w1, w2, w3, w4, w_max;
  int h1, h2, h3, h4, h_max;
  w1 = sz1.width();
  w2 = sz2.width();
  w3 = sz3.width();
  w4 = sz4.width();
  h1 = sz1.height();
  h2 = sz2.height();
  h3 = sz3.height();
  h4 = sz4.height();

  w_max = (w1 > w2)    ? w1 : w2;
  w_max = (w3 > w_max) ? w3 : w_max;
  w_max = (w4 > w_max) ? w4 : w_max;
  h_max = (h1 > h2)    ? h1 : h2;
  h_max = (h3 > h_max) ? h3 : h_max;
  h_max = (h4 > h_max) ? h4 : h_max;
  QSize sz(w_max, h_max);
  lFN     ->resize(sz);
  lGN     ->resize(sz);
  lTitle  ->resize(sz);
  lCompany->resize(sz);

  lFN     ->setMinimumSize(sz);
  lGN     ->setMinimumSize(sz);
  lTitle  ->setMinimumSize(sz);
  lCompany->setMinimumSize(sz);

  int yPos = tMargin + lFN->height()+9;
  
  lFN->move(lMargin, tMargin);
  lGN->move(lMargin, yPos);
  yPos += lGN->height()+9;
  lTitle->move(lMargin, yPos);
  yPos += lTitle->height()+9;
  lCompany->move(lMargin, yPos);
  
  leFN      = new QLineEdit(w);
  leGN      = new QLineEdit(w);
  leTitle   = new QLineEdit(w);
  leCompany = new QLineEdit(w);

  leFN     ->setFont(f);
  leGN     ->setFont(f);
  leTitle  ->setFont(f);
  leCompany->setFont(f);

  w1 = lMargin + w_max + 8;
  h2 = leFN->sizeHint().height();
  yPos = tMargin-2;
  leFN     ->setGeometry(w1, yPos, 250, h2);
  yPos += lFN->height() + 8;
  leGN     ->setGeometry(w1, yPos, 250, h2);
  yPos += lGN->height() + 8;
  leTitle  ->setGeometry(w1, yPos, 250, h2);
  yPos += lTitle->height() + 8;
  leCompany->setGeometry(w1, yPos, 250, h2);
  
  lFN     ->setBuddy(leFN);
  lGN     ->setBuddy(leGN);
  lTitle  ->setBuddy(leTitle);
  lCompany->setBuddy(leCompany);

  rbPhone1 = new QRadioButton(w);
  rbPhone2 = new QRadioButton(w);
  rbPhone3 = new QRadioButton(w);
  rbPhone4 = new QRadioButton(w);
  rbPhone5 = new QRadioButton(w);

  sz = rbPhone1->sizeHint();
  rbPhone1->resize(sz);
  rbPhone2->resize(sz);
  rbPhone3->resize(sz);
  rbPhone4->resize(sz);
  rbPhone5->resize(sz);

  rb = new QButtonGroup();
  rb->insert(rbPhone1);
  rb->insert(rbPhone2);
  rb->insert(rbPhone3);
  rb->insert(rbPhone4);
  rb->insert(rbPhone5);
  
  cbPhone1 = new QComboBox(w);
  cbPhone2 = new QComboBox(w);
  cbPhone3 = new QComboBox(w);
  cbPhone4 = new QComboBox(w);
  cbPhone5 = new QComboBox(w);

  for (i=0; i<8 && pAppInfo->phoneLabels[i][0]; i++)
    {
      cbPhone1->insertItem(pAppInfo->phoneLabels[i]);
      cbPhone2->insertItem(pAppInfo->phoneLabels[i]);
      cbPhone3->insertItem(pAppInfo->phoneLabels[i]);
      cbPhone4->insertItem(pAppInfo->phoneLabels[i]);
      cbPhone5->insertItem(pAppInfo->phoneLabels[i]);
    }

  //  is this a new address?
  if (a->getFN() == 0)
    {
      // yes, init. with defaults
      cbPhone1->setCurrentItem(0);
      cbPhone2->setCurrentItem(1);
      cbPhone3->setCurrentItem(2);
      cbPhone4->setCurrentItem(3);
      cbPhone5->setCurrentItem(4);
    }
  else
    {
      cbPhone1->setCurrentItem(a->getPhoneLabelIdx0());
      cbPhone2->setCurrentItem(a->getPhoneLabelIdx1());
      cbPhone3->setCurrentItem(a->getPhoneLabelIdx2());
      cbPhone4->setCurrentItem(a->getPhoneLabelIdx3());
      cbPhone5->setCurrentItem(a->getPhoneLabelIdx4());
    }

  sz = cbPhone1->sizeHint();
  cbPhone1->resize(sz);
  cbPhone2->resize(sz);
  cbPhone3->resize(sz);
  cbPhone4->resize(sz);
  cbPhone5->resize(sz);

  cbPhone1->setMinimumSize(sz);
  cbPhone2->setMinimumSize(sz);
  cbPhone3->setMinimumSize(sz);
  cbPhone4->setMinimumSize(sz);
  cbPhone5->setMinimumSize(sz);

  yPos = lCompany->y() + 2*tMargin;
  int xPos = lMargin + lMargin + lMargin;

  cbPhone1->move(xPos, yPos); 
  rbPhone1->move(lMargin, yPos+4);
  
  yPos += cbPhone1->height() + 5;
  cbPhone2->move(xPos, yPos); 
  rbPhone2->move(lMargin, yPos+4);

  yPos += cbPhone2->height() + 5;
  cbPhone3->move(xPos, yPos); 
  rbPhone3->move(lMargin, yPos+4);

  yPos += cbPhone3->height() + 5;
  cbPhone4->move(xPos, yPos); 
  rbPhone4->move(lMargin, yPos+4);

  yPos += cbPhone4->height() + 5;
  cbPhone5->move(xPos, yPos); 
  rbPhone5->move(lMargin, yPos+4);

  QLabel *lPrivate = new QLabel(w);
  lPrivate->setText("Private");
  lPrivate->setAlignment(AlignRight);
  lPrivate->resize(sz);
  lPrivate->setMinimumSize(sz);
  lPrivate->move(xPos, cbPhone5->y()+42);

  QLabel *lCat = new QLabel(w);
  lCat->setText("Category");
  lCat->setAlignment(AlignRight);
  lCat->adjustSize();

  lePhone1 = new QLineEdit(w);
  lePhone2 = new QLineEdit(w);
  lePhone3 = new QLineEdit(w);
  lePhone4 = new QLineEdit(w);
  lePhone5 = new QLineEdit(w);

  lePhone1->setFont(f);
  lePhone2->setFont(f);
  lePhone3->setFont(f);
  lePhone4->setFont(f);
  lePhone5->setFont(f);

  cbPrivate = new QCheckBox(w);

  cbCat = new QComboBox(w);

  for(i=0; i<16; i++)
    {
      // append category name only if not empty !
      if (pAppInfo->category.name[i][0])
        cbCat->insertItem(pAppInfo->category.name[i]);
    }
  
  cbCat->adjustSize();
  
  int wle = leFN->x()+leFN->width()-cbPhone1->x()-cbPhone1->width()-lMargin;
  
  w1 = cbPhone1->x() + cbPhone1->sizeHint().width() + lMargin;
  h2 = lePhone1->sizeHint().height();
  yPos = cbPhone1->y();
  lePhone1->setGeometry(w1, yPos, wle, h2);
  yPos += cbPhone1->height() + 6;
  lePhone2->setGeometry(w1, yPos, wle, h2);
  yPos += cbPhone1->height() + 6;
  lePhone3->setGeometry(w1, yPos, wle, h2);
  yPos += cbPhone1->height() + 6;
  lePhone4->setGeometry(w1, yPos, wle, h2);
  yPos += cbPhone1->height() + 6;
  lePhone5->setGeometry(w1, yPos, wle, h2);

  cbPrivate->resize(cbPrivate->sizeHint());
  cbPrivate->move(lePhone5->x(), lPrivate->y());

  lCat ->move(cbPrivate->x()+32, cbPrivate->y());
  cbCat->move(lCat->x()+lCat->width()+bttnMargin, lCat->y()-6);

  tab->addTab(w, "&Name");
  
  // page two
  w = new QWidget(tab, "page two");

  QLabel *lAddress = new QLabel(w);
  QLabel *lZIP     = new QLabel(w);
  QLabel *lTown    = new QLabel(w);
  QLabel *lState   = new QLabel(w);
  QLabel *lCountry = new QLabel(w);
  QLabel *lDefined1= new QLabel(w);
  QLabel *lDefined2= new QLabel(w);
  QLabel *lDefined3= new QLabel(w);
  QLabel *lDefined4= new QLabel(w);

  lAddress ->setText(pAppInfo->labels[8]);
  lZIP     ->setText(pAppInfo->labels[11]);
  lTown    ->setText(pAppInfo->labels[9]);
  lState   ->setText(pAppInfo->labels[10]);
  lCountry ->setText(pAppInfo->labels[12]);
  lDefined1->setText(pAppInfo->labels[14]);
  lDefined2->setText(pAppInfo->labels[15]);
  lDefined3->setText(pAppInfo->labels[16]);
  lDefined4->setText(pAppInfo->labels[17]);
  
  lAddress ->setAlignment(AlignRight);
  lZIP     ->setAlignment(AlignRight);
  lTown    ->setAlignment(AlignRight);
  lState   ->setAlignment(AlignRight);
  lCountry ->setAlignment(AlignRight);
  lDefined1->setAlignment(AlignRight);
  lDefined2->setAlignment(AlignRight);
  lDefined3->setAlignment(AlignRight);
  lDefined4->setAlignment(AlignRight);

  sz.setWidth(85);
  sz.setHeight(lFN->height());
  lAddress ->resize(sz);
  lZIP     ->resize(sz);
  lTown    ->resize(sz);
  lState   ->resize(sz);
  lCountry ->resize(sz);
  lDefined1->resize(sz);
  lDefined2->resize(sz);
  lDefined3->resize(sz);
  lDefined4->resize(sz);

  lAddress ->setMinimumSize(sz);
  lZIP     ->setMinimumSize(sz);
  lTown    ->setMinimumSize(sz);
  lState   ->setMinimumSize(sz);
  lCountry ->setMinimumSize(sz);
  lDefined1->setMinimumSize(sz);
  lDefined2->setMinimumSize(sz);
  lDefined3->setMinimumSize(sz);
  lDefined4->setMinimumSize(sz);

  yPos = tMargin;
  lAddress ->move(lMargin, yPos);

  if (!bUS) {
    yPos += 70+8;
    lZIP->move(lMargin, yPos);
    yPos += lFN->height() + 8;
    lTown->move(lMargin, yPos);
    yPos += lFN->height() + 8;
    lState->move(lMargin, yPos);
  } else {
    yPos += 70+8;
    lTown->move(lMargin, yPos);
    yPos += lFN->height() + 8;
    lState->move(lMargin, yPos);
    yPos += lFN->height() + 8;
    lZIP->move(lMargin, yPos);
  }

  yPos += lFN->height() + 8;
  lCountry->move(lMargin, yPos);
  yPos += 30;
  lDefined1->move(lMargin, yPos);
  yPos += lFN->height() + 8;
  lDefined2->move(lMargin, yPos);
  yPos += lFN->height() + 8;
  lDefined3->move(lMargin, yPos);
  yPos += lFN->height() + 8;
  lDefined4->move(lMargin, yPos);

  mlAddress  = new QMultiLineEdit(w);
  mlAddress->setText("");
  mlAddress->setMinimumSize(QSize(250, 70));
  mlAddress->setFont(f);
  
  if (!bUS) {
    leZIP      = new QLineEdit(w);
    leTown     = new QLineEdit(w);
    leState    = new QLineEdit(w);
  } else {
    leTown     = new QLineEdit(w);
    leState    = new QLineEdit(w);
    leZIP      = new QLineEdit(w);
  }
  leCountry  = new QLineEdit(w);
  leDefined1 = new QLineEdit(w);
  leDefined2 = new QLineEdit(w);
  leDefined3 = new QLineEdit(w);
  leDefined4 = new QLineEdit(w);

  leZIP     ->setFont(f);
  leTown    ->setFont(f);
  leState   ->setFont(f);
  leCountry ->setFont(f);
  leDefined1->setFont(f);
  leDefined2->setFont(f);
  leDefined3->setFont(f);
  leDefined4->setFont(f);

  w1   = lMargin + 85 + 8;
  h2   = leFN->sizeHint().height();
  yPos = tMargin-2;
  mlAddress->setGeometry(w1, yPos, 250, 70);
  yPos += mlAddress->height() + 8;

  if (!bUS) {
    leZIP->setGeometry(w1, yPos, 250, h2);
    yPos += lAddress->height() + 8;
    leTown->setGeometry(w1, yPos, 250, h2);
    yPos += lAddress->height() + 8;
    leState->setGeometry(w1, yPos, 250, h2);
  } else {
    leTown->setGeometry(w1, yPos, 250, h2);
    yPos += lAddress->height() + 8;
    leState->setGeometry(w1, yPos, 250, h2);
    yPos += lAddress->height() + 8;
    leZIP->setGeometry(w1, yPos, 250, h2);
  }

  yPos += lAddress->height() + 8;
  leCountry->setGeometry(w1, yPos, 250, h2);
  yPos += 30;
  leDefined1->setGeometry(w1, yPos, 250, h2);
  yPos += lAddress->height() + 8;
  leDefined2->setGeometry(w1, yPos, 250, h2);
  yPos += lAddress->height() + 8;
  leDefined3->setGeometry(w1, yPos, 250, h2);
  yPos += lAddress->height() + 8;
  leDefined4->setGeometry(w1, yPos, 250, h2);
  yPos += lAddress->height() + 8;

  tab->addTab(w, "&Adresses");

  // page three
  w = new QWidget(tab, "page three");
  
  mlNote = new QMultiLineEdit(w, 0);
  mlNote->setGeometry(lMargin, tMargin, 
                      DlgWidth-3*lMargin, DlgHeight-6*tMargin); 
  mlNote->setFont(f);

  tab->addTab(w, "No&te");

  tab->setCancelButton();
  connect(tab, SIGNAL(applyButtonPressed()),  SLOT(apply()));
  connect(tab, SIGNAL(cancelButtonPressed()), SLOT(cancel()));
  connect(tab, SIGNAL(aboutToShow()),         SLOT(setup()));

  adjustSize();

  show();
  tab->show();
}

AddressDlg::~AddressDlg()
{
  ;
}

void AddressDlg::apply()
{
  QString s;
  int i=0;
  
  if (!A)
    return;

  if (rbPhone1->isChecked())
    i = 0;
  else if(rbPhone2->isChecked())
    i = 1;
  else if(rbPhone3->isChecked())
    i = 2;
  else if(rbPhone4->isChecked())
    i = 3;
  else if(rbPhone5->isChecked())
    i = 4;

  A->putShowPhone(i);
   
  s = leFN->text();
  A->putFN((char *)s.data());

  s = leGN->text();
  A->putGN((char *)s.data());

  s = leTitle->text();
  A->putTitle((char *)s.data());

  s = leCompany->text();
  A->putCompany((char *)s.data());

  s = lePhone1->text();
  A->putPhone1((char *)s.data());

  s = lePhone2->text();
  A->putPhone2((char *)s.data());

  s = lePhone3->text();
  A->putPhone3((char *)s.data());

  s = lePhone4->text();
  A->putPhone4((char *)s.data());

  s = lePhone5->text();
  A->putPhone5((char *)s.data());

  s = mlAddress->text();
  A->putAddress((char *)s.data());

  s = leZIP->text();
  A->putZIP((char *)s.data());

  s = leTown->text();
  A->putTown((char *)s.data());

  s = leState->text();
  A->putState((char *)s.data());

  s = leCountry->text();
  A->putCountry((char *)s.data());

  s = leDefined1->text();
  A->putDefined1((char *)s.data());

  s = leDefined2->text();
  A->putDefined2((char *)s.data());

  s = leDefined3->text();
  A->putDefined3((char *)s.data());

  s = leDefined4->text();
  A->putDefined4((char *)s.data());

  s = mlNote->text();
  A->putNote((char *)s.data());

  A->putPrivate(cbPrivate->isChecked());

  A->putModified(TRUE);

  A->setCat(cbCat->currentItem());

  A->putPhoneLabelIdx0(cbPhone1->currentItem());
  A->putPhoneLabelIdx1(cbPhone2->currentItem());
  A->putPhoneLabelIdx2(cbPhone3->currentItem());
  A->putPhoneLabelIdx3(cbPhone4->currentItem());
  A->putPhoneLabelIdx4(cbPhone5->currentItem());
  
  if (bC != 0)
    *bC = FALSE;
}

void AddressDlg::setup()
{
  if (!A)
    return;
  
  QString s;
  int i;
  
  i = A->getShowPhone();
  switch(i)
    {
    case 0:
      rbPhone1->setChecked(TRUE);
      break;
    case 1:
      rbPhone2->setChecked(TRUE);
      break;
    case 2:
      rbPhone3->setChecked(TRUE);
      break;
    case 3:
      rbPhone4->setChecked(TRUE);
      break;
    case 4:
      rbPhone5->setChecked(TRUE);
      break;
    default:    
      rbPhone1->setChecked(TRUE);
      break;
    }
  
  s = A->getFN();
  if (!s.isEmpty())
    leFN->setText(s);
  
  s = A->getGN();
  if (!s.isEmpty())
    leGN->setText(s);
  
  s = A->getTitle();
  if (!s.isEmpty())
    leTitle->setText(s);
  
  s = A->getCompany();
  if (!s.isEmpty())
    leCompany->setText(s);
  
  s = A->getPhone1();
  if (!s.isEmpty())
    lePhone1->setText(s);

  s = A->getPhone2();
  if (!s.isEmpty())
    lePhone2->setText(s);
  
  s = A->getPhone3();
  if (!s.isEmpty())
    lePhone3->setText(s);
  
  s = A->getPhone4();
  if (!s.isEmpty())
    lePhone4->setText(s);
  
  s = A->getPhone5();
  if (!s.isEmpty())
    lePhone5->setText(s);
  
  s = A->getAddress();
  if (!s.isEmpty())
    mlAddress->setText(s);
  
  s = A->getZIP();
  if (!s.isEmpty())
    leZIP->setText(s);
  
  s = A->getTown();
  if (!s.isEmpty())
    leTown->setText(s);
  
  s = A->getState();
  if (!s.isEmpty())
    leState->setText(s);
  
  s = A->getCountry();
  if (!s.isEmpty())
    leCountry->setText(s);
  
  s = A->getDefined1();
  if (!s.isEmpty())
    leDefined1->setText(s);
  
  s = A->getDefined2();
  if (!s.isEmpty())
    leDefined2->setText(s);
  
  s = A->getDefined3();
  if (!s.isEmpty())
    leDefined3->setText(s);
  
  s = A->getDefined4();
  if (!s.isEmpty())
    leDefined4->setText(s);

  s = A->getNote();
  if (!s.isEmpty())
    mlNote->setText(s);

  cbPrivate->setChecked(A->getPrivate());

  cbCat->setCurrentItem(A->getCat());

  leFN->setFocus();
}

void AddressDlg::cancel()
{
  if (bC != 0)
    *bC = TRUE;
}
