/* Copyright (C) 1997, 1998, 1999, 2000 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>

   $Id: rcsvfile.cpp,v 1.8 2000/05/07 10:10:03 mw Exp $
*/


#include "rcsvfile.h"

#include "rcsvfile.moc"

#include "pi-dlp.h"
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>


ReadCSVFile::ReadCSVFile(QFile &f, bool *bCancel, QString *qsAppInfo)
  : QObject()
{
  int i;
  Address *a;
  AInfo *info;
  char buf[8192], *p, *val;

  bError = bCancel;
  if (bError)
    *bError = FALSE;

  name = new char[strlen(f.name()) + 1];
  strcpy(name, f.name());

  nentries = 0;
  alist = new QList<Address>;
  alist->setAutoDelete(TRUE);
  ilist = new QList<AInfo>;
  ilist->setAutoDelete(TRUE);

  if (qsAppInfo && qsAppInfo->length())
    // FIXME: look if $HOME specified
    strcpy(buf, qsAppInfo->data());
  else
    {
      // Default: read appinfo file from ~/.pilotmgr/SyncAB/pilot.appinfo
      memset(&aai, 0x00, sizeof(AddressAppInfo));
      char *home = getpwuid(getuid())->pw_dir;

      if (home)
        strcpy(buf, home);
      else
      {
        buf[0] = '~';
        buf[1] = 0;
      }
      strcat(buf, "/.pilotmgr/SyncAB/pilot.appinfo");
    }
  
  QFile *appinfo = new QFile(buf);

  if (!appinfo->open(IO_ReadOnly))
    {
      if (bError) 
        *bError = TRUE;
      delete appinfo;
      return;
    }

  appinfo->readLine(buf, sizeof(buf)-1);
  char *ptmp;
  for (i=0; i < 16; i++)
  {
    appinfo->readLine(buf, sizeof(buf)-1);

    // look for '\n'
    ptmp = strchr(buf, 0x0D);
    if (ptmp)
      // found, 'delete' it
      *ptmp = 0x00;

    memset(aai.category.name[i], 0x00, 16);
    strncpy(aai.category.name[i], buf, strlen(buf)-1);
  }
  for (i=0; i < 22; i++)
  {
    appinfo->readLine(buf, sizeof(buf)-1);

    // look for '\n'
    ptmp = strchr(buf, 0x0D);
    if (ptmp)
      // found, 'delete' it
      *ptmp = 0x00;
    memset(aai.labels[i], 0x00, 16);
    strncpy(aai.labels[i], buf, strlen(buf)-1);
  }
  for(i=3; i<8; i++)
    strcpy(aai.phoneLabels[i-3], aai.labels[i]);
  for(i=19; i<22; i++)
    strcpy(aai.phoneLabels[i-19+5], aai.labels[i]);
  appinfo->close();
  delete appinfo;

  // open the CSV-File

  if (!f.open(IO_ReadOnly))
    {
      if (bError) 
        *bError = TRUE;
      return;
    }

  while (f.readLine(buf, sizeof(buf)-1))
    {
      a = new Address;
      memset(a, 0x00, sizeof(Address));
      info = new AInfo;
      memset(info, 0x00, sizeof(AInfo));

      // debug("DBG: record -> %20s ...", buf);

      // parse record
      p = buf;
      val = popCSV(&p);  // this is the record id#
      for (i=0; i < 19 && *p; i++)
      {
        val = popCSV(&p);
        a->entry[i] = new char[strlen(val)+1];
        strcpy(a->entry[i], val);
      }
      val = popCSV(&p); // showPhone
      a->showPhone = atoi(val);
      val = popCSV(&p); // phoneLabels
      for (i=0; i < 5; i++)
      {
        a->phoneLabel[i] = atoi(val);
        while (*val && *val != ' ') val++;
        val++;
      }
      alist->append(a);
      val = popCSV(&p); // category
      info->category = atoi(val);
      val = popCSV(&p); // private
      info->secret = atoi(val);
      ilist->append(info);
      nentries++;

      if (f.atEnd())
	break;
    }

  f.close();  
}

ReadCSVFile::~ReadCSVFile()
{
  delete name;
  delete alist;
  delete ilist;
}

int ReadCSVFile::getNEntries()
{
  return (nentries);
}

int ReadCSVFile::readRecord(int i, Address *ap, int *iAttrs, int *iCat)
{
  if (i < 0 || i >= (int)alist->count() || i >= (int)ilist->count())
    return 0;

  memcpy(ap, alist->at(i), sizeof(Address));
  *iCat = ilist->at(i)->category;
  *iAttrs = ilist->at(i)->secret ? dlpRecAttrSecret : 0;

  return 1;
}


int ReadCSVFile::getAppInfo(AddressAppInfo *aaip)
{
  memcpy(aaip, &aai, sizeof(AddressAppInfo));
  return 0;
}

const char *ReadCSVFile::getName()
{
  return name;
}

time_t ReadCSVFile::getCreateDate()
{
  return 0;
}

time_t ReadCSVFile::getModifyDate()
{
  return 0;
}

time_t ReadCSVFile::getBackupDate()
{
  return 0;
}



char * ReadCSVFile::popCSV(char **p)
{
  char *val, *valptr, *scan;
  char c;
  int bs = 0;
  int quote_mode = (**p == '"');

  if (quote_mode) (*p)++;
  val = valptr = scan = *p;

  while (c = *scan)
  {
    if (c == '\n') { scan++; continue; }
    *valptr++ = c;
    if ( quote_mode && c == '"' && scan[1] == '"')
    {
      scan+=2;
      continue;
    }
    if ( ( quote_mode && c == '"') || (!quote_mode && c == ',') )
    {
      *--valptr = 0;
      if (quote_mode && scan[1] == ',') scan++;
      *p = scan+1;
      return val;
    }
    if (c == 'n' && bs > 0)
    {
      valptr -= (bs+3)/2;
      *valptr++ = (bs%2) ? '\n' : 'n';
    }
    if (c == '\\') bs++; else bs=0;
    scan++;
  }
  *valptr = 0;
  *p = scan;
  return val;
}
