/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#include "wpdbfile.h"

#include "wpdbfile.moc"


WritePDBFile::WritePDBFile(const char *acFileName, struct DBInfo *db, bool *bCancel)
  : QObject()
{
  bError = bCancel;
  if (bError)
    *bError = FALSE;  

  pf = pi_file_create((char *)acFileName, db);
  if (!pf && bError)
    *bError = TRUE;
}

WritePDBFile::~WritePDBFile()
{
  ;
}

int WritePDBFile::closeFile()
{
  int iError = pi_file_close(pf);
  pf = 0;
  return (iError);
}

int WritePDBFile::appendRecord(void *buf, int size, int attrs, int cat, long uid)
{
  if (pf)
    return (pi_file_append_record(pf, buf, size, attrs, cat, uid));
  else
    return (-1);
}

int WritePDBFile::setAppInfo(void *datap, int size)
{
  if (pf)
    return (pi_file_set_app_info(pf, datap, size));
  else
    return (-1);
}

int WritePDBFile::setInfo(struct DBInfo *db)
{
  if (pf)
    return (pi_file_set_info(pf, db));
  else
    return (-1);
}


 



