/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#include "rpdbfile.h"

#include "rpdbfile.moc"

extern "C" {
// TODO: forward declarations (because of a name conflict of h-files I
//       cannot easily include the proper h-file).
  extern int unpack_Address(Address *a, unsigned char *record, int size);
  extern int unpack_AddressAppInfo(AddressAppInfo *a, unsigned char *record, int size);
}


ReadPDBFile::ReadPDBFile(QFile &f, bool *bCancel)
  : QObject()
{
  bError = bCancel;
  if (bError)
    *bError = FALSE;
  
  // open the PDB-File
  pf = pi_file_open((char *)f.name());

  if (!pf)
    {
      if (bError) 
        *bError = TRUE;
      return;
    }
  
  pi_file_get_info(pf, &info);
  
  int c=strcmp(info.name, "AddressDB");
  
  if (c)
    {
      pi_file_close(pf);
      pf = 0;
      if (bError) 
        *bError = TRUE;
      return;
    }
}

ReadPDBFile::~ReadPDBFile()
{
  if (pf)
    {
      pi_file_close(pf);
      pf = 0;
    }
}

int ReadPDBFile::getNEntries()
{
  int n;
  pi_file_get_entries(pf, &n);
  return (n);
}

int ReadPDBFile::readRecord(int i, Address *ap, int *iAttrs, int *iCat)
{
  void *buf;
  int iSize;
  unsigned long lUid;
  pi_file_read_record(pf, i, &buf, &iSize, iAttrs, iCat, &lUid);
  return (unpack_Address(ap, (unsigned char *)buf, iSize));
}


int ReadPDBFile::getAppInfo(AddressAppInfo *aaip)
{
  void *ai;
  int size;
  pi_file_get_app_info(pf, &ai, &size);
  return (unpack_AddressAppInfo(aaip, (unsigned char *)ai,
				sizeof(AddressAppInfo)));
}

const char *ReadPDBFile::getName()
{
  return (info.name);
}

time_t ReadPDBFile::getCreateDate()
{
  return (info.createDate);
}

time_t ReadPDBFile::getModifyDate()
{
  return (info.modifyDate);
}

time_t ReadPDBFile::getBackupDate()
{
  return (info.backupDate);
}







