/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#ifndef _PILOT_H
#define _PILOT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <pi-socket.h>
#include <pi-dlp.h>
#include <pi-file.h>

#include <qfile.h>
#include <qobject.h>
#include <qprogdlg.h>


class Pilot : public QObject
{
  Q_OBJECT

public:
  Pilot();
  Pilot(QWidget *p, int iTimeout=30);
  ~Pilot();

  enum ConnectResult
  {
    Success          =  0,
    AlreadyConnected = -1,
    SocketError      = -2,
    BindError        = -3,
    ListenError      = -4,
    TimeoutError     = -5,
    Cancelled        = -6,
    AcceptError      = -7,
    SelectError      = -8,
    DeviceError      = -9
  };

  enum RetrieveResult
  {
    RetrieveSuccess  =  0,
    ConduitError     = -1,
    FindDBError      = -2,
    FileCreateError  = -3,
    OpenDBError      = -4,
    ReadDBInfoError  = -5,
    ReadRecordError  = -6,
    FileAppendError  = -7,
    CloseDBError     = -8,
    NoSocketError    = -9
  };

  enum InstallResult
  {
    InstallSuccess     =  0,
    InstConduitError   = -1,
    InstOpenError      = -2,
    InstCreateError    = -3,
    InstCloseDBError   = -4
  };
  
  ConnectResult connect(QString &qsDeviceName, bool bTestDevice=TRUE);
  void disconnect();
  bool getUserName(QString &qsName);
  bool getUserID(unsigned long &userID);
  bool getRomVersion(unsigned long &version);
  bool getLocale(unsigned long &locale);
  bool getName(QString &qsName);
  bool getRomSize(unsigned long &romSize);
  bool getRamSize(unsigned long &ramSize);
  bool getRamFree(unsigned long &ramFree);
  bool getCardName(QString &qsName);
  bool getCardManufacturer(QString &qsName);
  RetrieveResult retrieveDB(QString qsDBName, QString qsFName);
  InstallResult  installDB(QString qsDBName, QString qsFName);
  void purgeDB();
  
private slots:

private:
  void     voidSyncFlags();

  int      sd;

  struct PilotUser userInfo;
  struct SysInfo   sysInfo;
  struct CardInfo  cardInfo;

  int    iTimeout;
  QProgressDialog *pilotProgress;
  QSize sz;
  QString qsLabel;
};

#endif
