/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#ifndef PIADDRESS_H
#define PIADDRESS_H

#include <time.h>

#include "address.h"
#include "addrrecord.h"
#include "common.h"
#include "Toolbar.h"
#include "StatusBar.h"
#include "ListBox.h"

#include <pi-file.h>

#include <qevent.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qlist.h>
#include <qmainwindow.h>
#include <qpushbt.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qmlined.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qpopmenu.h>
#include <qprinter.h>

#define pi_mktag(c1,c2,c3,c4) (((c1)<<24)|((c2)<<16)|((c3)<<8)|(c4))

class PiAddress : public QWidget
{
    Q_OBJECT
public:
    PiAddress( QWidget *parent=0, const char *name=0 );
    ~PiAddress();
    
public slots:
    void rMouseActivated();
    void quit();
    void newCat(int idx, char *s);
    void deleteCat(int idx);
    void changeCat(int idx, char *s);

protected:
    void    paintEvent(QPaintEvent *);

signals:

private slots:
    void open();
    void readFile(QFile &, bool bPMgr=FALSE);
    void rereadFile();
    void rereadConfig();
    void initDefValues();
    void writeFile();
    void news();
    void save();
    void save_as();
    void closeDoc();
    void about();
    void copyright();
    void helpFAQ();
    void info();
    void aboutQt();
    void exportCSV();
    void exportLDIF();
    void exportXML();
    void importCSV();
    void importPMgr();
    void importXML();
    void printer();
    void readPilot();
    void writePilot();
    void purgePilot();
    void infoPilot();
    void editAddr(int);
    void editAddr();
    void newAddr();
    void showEditDlg(AddressRecord *);
    void cloneAddr();
    void showNote();
    void editCat();
    void enableButtons(int);
    void displayAddresses();
    void searchRecord(const char *);
    void searchRecord(const QString &t);
    void statusMessageReady();
    void displayRecord(int);
    void disableButtons();
    void deleteAddr();
    void deleteAddresses();
    void execUser1();
    void messageBox(QString &s);
    
private:
    bool           bModified;
    QMenuBar      *menu;
    QComboBox     *cat;
    ListBox       *lbAddr;
    QLabel        *lAddr;
    
    QLabel        *lCat;
    QLabel        *lSearch;
    QLineEdit     *leSearch;
    QPushButton   *pbEdit;
    QPushButton   *pbNew;
    QPushButton   *pbClone;
    QPushButton   *pbDelete;
    QPushButton   *pbNote;
    QPushButton   *pbCatEdit;

    Toolbar        toolBar;
    void           populateToolbar();
    int            idToolbarSave, idToolbarPrint;
    int            idToolbarRead, idToolbarWrite;
    int            idToolbarExport;

    StatusBar      statusBar;
    int            statusMsg;
    int            statusDevice;
    int            statusCount;
    int            statusFname;
    void           updateStatusCount();
    int            confirmNoSave();
    int            getIndex(int);
    void           initCat();
    void           fillAddress(AddressRecord *addrRec, Address *a);
    void           fillAddrRecord(AddressRecord *addrRec, Address *a, 
                   int iCat=0, bool bPrivate=FALSE);
    bool           fileOverwrite();

    void           loadDefaultDB();
    void           loadConfigFile(QString *qsFile);
    void           loadSystemConfigFile();
    void           loadUserConfigFile();
    void           evaluateConfValues();
    char           *getDir();

    void           startTimer4StatusMsg();

    int            initAppInfo();
    int            fillAppInfo(char *p);
    AddressAppInfo *pAppInfo;
    struct DBInfo  dbInfo;
    
    
    QList<AddressRecord> *AddrList;
    void           insertSorted(AddressRecord *);

    QPopupMenu    *rMouseMenu;
    int           idEdit, idNew, idClone, idDelete, idDelCat, idExec1;
    QPopupMenu    *print;
    int           printID;

    QPopupMenu    *pilotMenu;
    int            pilotRead, pilotWrite, pilotPurge, pilotList;

    QPopupMenu    *recordMenu;
    int           idRecordEdit, idRecordNew, idRecordClone, 
                  idRecordDelete, idRecordDeleteAddresses, idRecordExec1;
    
    QString        qsFname;
    QPopupMenu    *fileMenu;
    int           idReread, idSave, idSaveAs, idExport, idExportLDIF, 
                  idExportXML;

    QPopupMenu    *helpMenu;
    int           idFAQ;
    
    QPrinter      *pPrinter;
    int           iPrintingPointSize;
    QString       qsPrintingFontName;
    QString       qsPrintingFormat;
    QString       qsPrintTo;
    QString       qsPrintFileName;
    int           aiPrintingFields[40];
    void          initPrintingFields();
    void          printAddress(AddressRecord *a, QPainter *p, int x, int y);

    void          encodeEntities(const char *s, QString &qsDest);

    QString       qsHelpApplication;
    QString       qsDeviceName;
    QString       qsDefaultDB;
    
    QString       qsListFont;
    QString       qsRecordFont;
    QString       qsEditFont;

    QString       qsSrcCodePage;
    QString       qsDstCodePage;
    void          transformCodePage(Address *a);
    void          transformAddress(Address *a, unsigned short int *table);

    QString       qsPMgrAppInfo;
    
    time_t        creaTime;
    time_t        modTime;
    time_t        backupTime;

    int           iDebug;

    bool          bDisablePilotFunctions;
    bool          bCheckDevice;

    // LDIF configuration variables
    int       iLDIFtelephonenumber;
    int       iLDIFhomephone;
    int       iLDIFfacsimiletelephonenumber;
    int       iLDIFmail;
    int       iLDIFpagerphone;
    int       iLDIFcellphone;

    // User program Variable
    QString   qsUserProg1;

    // confirm all dangerous operations
    bool      bConfirmOps;
};

#endif

