/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#include "addrrecord.h"

#include <string.h>

#include "addrrecord.moc"

AddressRecord::AddressRecord()
{
  memset(&Addr, 0x00, sizeof(Address));
  iCat = 0;
  bModified = FALSE;
}

AddressRecord::AddressRecord(const Address *a, int c, bool bMod)
{
  memcpy(&Addr, (const void *)a, sizeof(Address));
  iCat = c;
  bModified = bMod;
}

AddressRecord::~AddressRecord()
{
  for(int i=0;i<19;i++)
    if (Addr.entry[i])
      delete Addr.entry[i];
}


void AddressRecord::cloneAddress(Address *a)
{
  memset(a, 0x00, sizeof(Address));

  // create duplicate entries of each field!
  if (Addr.entry[0])
    a->entry[ 0] = strdup(Addr.entry[ 0]);
  if (Addr.entry[1])
    a->entry[ 1] = strdup(Addr.entry[ 1]);
  if (Addr.entry[2])
    a->entry[ 2] = strdup(Addr.entry[ 2]);  
  if (Addr.entry[3])
    a->entry[ 3] = strdup(Addr.entry[ 3]);
  if (Addr.entry[4])
    a->entry[ 4] = strdup(Addr.entry[ 4]);
  if (Addr.entry[5])
    a->entry[ 5] = strdup(Addr.entry[ 5]);
  if (Addr.entry[6])
    a->entry[ 6] = strdup(Addr.entry[ 6]);
  if (Addr.entry[7])
    a->entry[ 7] = strdup(Addr.entry[ 7]);
  if (Addr.entry[8])
    a->entry[ 8] = strdup(Addr.entry[ 8]);
  if (Addr.entry[9])
    a->entry[ 9] = strdup(Addr.entry[ 9]);
  if (Addr.entry[10])
    a->entry[10] = strdup(Addr.entry[10]);
  if (Addr.entry[11])
    a->entry[11] = strdup(Addr.entry[11]);
  if (Addr.entry[12])
    a->entry[12] = strdup(Addr.entry[12]);
  if (Addr.entry[13])
    a->entry[13] = strdup(Addr.entry[13]);
  if (Addr.entry[14])
    a->entry[14] = strdup(Addr.entry[14]);
  if (Addr.entry[15])
    a->entry[15] = strdup(Addr.entry[15]);
  if (Addr.entry[16])
    a->entry[16] = strdup(Addr.entry[16]);
  if (Addr.entry[17])
    a->entry[17] = strdup(Addr.entry[17]);
  if (Addr.entry[18])
    a->entry[18] = strdup(Addr.entry[18]);

  a->phoneLabel[0] = Addr.phoneLabel[0];
  a->phoneLabel[1] = Addr.phoneLabel[1];
  a->phoneLabel[2] = Addr.phoneLabel[2];
  a->phoneLabel[3] = Addr.phoneLabel[3];
  a->phoneLabel[4] = Addr.phoneLabel[4];

  a->showPhone = Addr.showPhone;
}

// "put"-methods

void AddressRecord::putShowPhone(int i)
{
  Addr.showPhone = i;
}

void AddressRecord::putFN(const char *s)
{
  if (Addr.entry[0])
    delete Addr.entry[0];

  Addr.entry[0] = strdup(s);
}

void AddressRecord::putGN(const char *s)
{
  if (Addr.entry[1])
    delete Addr.entry[1];

  Addr.entry[1] = strdup(s);
}

void AddressRecord::putTitle(const char *s)
{
  if (Addr.entry[2])
    delete Addr.entry[2];

  Addr.entry[2] = strdup(s);
}

void AddressRecord::putCompany(const char *s)
{
  if (Addr.entry[3])
    delete Addr.entry[3];

  Addr.entry[3] = strdup(s);
}

void AddressRecord::putPhone1(const char *s)
{
  if (Addr.entry[4])
    delete Addr.entry[4];

  Addr.entry[4] = strdup(s);
}

void AddressRecord::putPhone2(const char *s)
{
  if (Addr.entry[5])
    delete Addr.entry[5];

  Addr.entry[5] = strdup(s);
}

void AddressRecord::putPhone3(const char *s)
{
  if (Addr.entry[6])
    delete Addr.entry[6];

  Addr.entry[6] = strdup(s);
}

void AddressRecord::putPhone4(const char *s)
{
  if (Addr.entry[7])
    delete Addr.entry[7];

  Addr.entry[7] = strdup(s);
}

void AddressRecord::putPhone5(const char *s)
{
  if (Addr.entry[8])
    delete Addr.entry[8];

  Addr.entry[8] = strdup(s);
}

void AddressRecord::putAddress(const char *s)
{
  if (Addr.entry[9])
    delete Addr.entry[9];

  Addr.entry[9] = strdup(s);
}

void AddressRecord::putZIP(const char *s)
{
  if (Addr.entry[10])
    delete Addr.entry[10];

  Addr.entry[10] = strdup(s);
}

void AddressRecord::putTown(const char *s)
{
  if (Addr.entry[11])
    delete Addr.entry[11];

  Addr.entry[11] = strdup(s);
}

void AddressRecord::putState(const char *s)
{
  if (Addr.entry[12])
    delete Addr.entry[12];

  Addr.entry[12] = strdup(s);
}

void AddressRecord::putCountry(const char *s)
{
  if (Addr.entry[13])
    delete Addr.entry[13];

  Addr.entry[13] = strdup(s);
}

void AddressRecord::putDefined1(const char *s)
{
  if (Addr.entry[14])
    delete Addr.entry[14];

  Addr.entry[14] = strdup(s);
}

void AddressRecord::putDefined2(const char *s)
{
  if (Addr.entry[15])
    delete Addr.entry[15];

  Addr.entry[15] = strdup(s);
}

void AddressRecord::putDefined3(const char *s)
{
  if (Addr.entry[16])
    delete Addr.entry[16];

  Addr.entry[16] = strdup(s);
}

void AddressRecord::putDefined4(const char *s)
{
  if (Addr.entry[17])
    delete Addr.entry[17];

  Addr.entry[17] = strdup(s);
}

void AddressRecord::putNote(const char *s)
{
  if (Addr.entry[18])
    delete Addr.entry[18];

  Addr.entry[18] = strdup(s);
}

void AddressRecord::putPrivate(bool b)
{
  bPrivate = b;
}

void AddressRecord::putModified(bool b)
{
  bModified = b;
}

void AddressRecord::setCat(int c)
{
  iCat = c;
}

void AddressRecord::putPhoneLabelIdx0(int i)
{
 Addr.phoneLabel[0] = i;
}

void AddressRecord::putPhoneLabelIdx1(int i)
{
 Addr.phoneLabel[1] = i;
}

void AddressRecord::putPhoneLabelIdx2(int i)
{
 Addr.phoneLabel[2] = i;
}

void AddressRecord::putPhoneLabelIdx3(int i)
{
 Addr.phoneLabel[3] = i;
}

void AddressRecord::putPhoneLabelIdx4(int i)
{
 Addr.phoneLabel[4] = i;
}

// "get"-methods
int AddressRecord::getShowPhone()
{
  return Addr.showPhone;
}

const char * AddressRecord::getFN()
{
  return Addr.entry[0];
}

const char * AddressRecord::getGN()
{
  return Addr.entry[1];
}

const char * AddressRecord::getTitle()
{
  return Addr.entry[2];
}

const char * AddressRecord::getCompany()
{
  return Addr.entry[3];
}

const char * AddressRecord::getPhone(int index)
{
  if (index >= 1 && index <= 5)
    return Addr.entry[index+3];
  else
    return "";
}

const char * AddressRecord::getPhone1()
{
  return Addr.entry[4];
}

const char * AddressRecord::getPhone2()
{
  return Addr.entry[5];
}

const char * AddressRecord::getPhone3()
{
  return Addr.entry[6];
}

const char * AddressRecord::getPhone4()
{
  return Addr.entry[7];
}

const char * AddressRecord::getPhone5()
{
  return Addr.entry[8];
}

const char * AddressRecord::getAddress()
{
  return Addr.entry[9];
}

const char * AddressRecord::getZIP()
{
  return Addr.entry[10];
}

const char * AddressRecord::getTown()
{
  return Addr.entry[11];
}

const char * AddressRecord::getState()
{
  return Addr.entry[12];
}

const char * AddressRecord::getCountry()
{
  return Addr.entry[13];
}

const char * AddressRecord::getDefined(int index)
{
  if (index >= 1 && index <= 4)
    return Addr.entry[index+13];
  else
    return "";
}

const char * AddressRecord::getDefined1()
{
  return Addr.entry[14];
}

const char * AddressRecord::getDefined2()
{
  return Addr.entry[15];
}

const char * AddressRecord::getDefined3()
{
  return Addr.entry[16];
}

const char * AddressRecord::getDefined4()
{
  return Addr.entry[17];
}

const char * AddressRecord::getNote()
{
  return Addr.entry[18];
}

bool AddressRecord::getPrivate()
{
  return bPrivate;
}

bool AddressRecord::getModified()
{
 return bModified;
}

int AddressRecord::getCat()
{
  return iCat;
}

int AddressRecord::getPhoneLabelIdx0()
{
  return Addr.phoneLabel[0];
}

int AddressRecord::getPhoneLabelIdx1()
{
  return Addr.phoneLabel[1];
}

int AddressRecord::getPhoneLabelIdx2()
{
  return Addr.phoneLabel[2];
}

int AddressRecord::getPhoneLabelIdx3()
{
  return Addr.phoneLabel[3];
}

int AddressRecord::getPhoneLabelIdx4()
{
  return Addr.phoneLabel[4];
}

int AddressRecord::getPhoneLabelIdx(int p)
{
  if (p >= 0 && p <= 5)
    return Addr.phoneLabel[p];
  else
    return -1;
}
