/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/


#ifndef _ADDRESS_H
#define _ADDRESS_H

enum
{
  entryLastname, entryFirstname, entryCompany,
  entryPhone1,   entryPhone2,  entryPhone3, entryPhone4, entryPhone5,
  entryAddress,  entryCity,    entryState, entryZip, entryCountry, entryTitle,
  entryCustom1,  entryCustom2, entryCustom3, entryCustom4,
  entryNote
};


typedef struct _CategoryAppInfo 
{
  unsigned int renamed[16];  // boolean array of categories with changed names
  char name[16][16];         // 16 categories of 15 cars+nul each
  unsigned char ID[16];
  unsigned char lastUniqueID;/* each category gets a unique ID, for sync
                                tracking purposes. Those from the Pilot are 
                                between 0 & 127. Those from the PC are
                                between 128 & 255. I'm not sure waht
                                role lastUniqueID plays */
} CategoryAppInfo;

typedef struct _AddressAppInfo
{
  CategoryAppInfo category;
  char labels[19+3][16];     // hairy to explain, obvious to look at
  int labelRenamed[19+3];    // list of booleans showing which labels
                             //    were modified
  char phoneLabels[8][16];   // duplications of some labels,
                             //    greatly reduce hair
  int country;
  int sortByCompany;
} AddressAppInfo;


typedef struct _Address
{
  int phoneLabel[5];
  int showPhone;
  char *entry[19];
} Address;

#endif





