/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/

#ifndef Toolbar_included
#define Toolbar_included

#include <qframe.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qpushbt.h>
#include <qsize.h>
#include <qtooltip.h>
#include <qbttngrp.h>


class Toolbar : public QButtonGroup
{
  Q_OBJECT

public:
    
  Toolbar
  ( 
   QWidget*	parent = NULL,
   const char*	name = NULL 
   );
    

  virtual ~Toolbar();

  uint Insert
  (
   const QPixmap&	pixmap,
   const QObject*	receiver,
   const char*	slot,
   const char*	toolTip = NULL,
   const char*	longToolTip = NULL,
   const char* name = NULL,
   const bool = FALSE
   );

  uint Insert
  (
   const int id,
   const QPixmap&	pixmap,
   const QObject*	receiver,
   const char*	slot,
   const char*	toolTip = NULL,
   const char*	longToolTip = NULL,
   const char* name = NULL,
   const bool = FALSE
   );
  // insert the pixmap into a button on the toolbar and connect to the
  // slot for when the button is pushed.  return the index number of the 
  // button.  the long tool tip will be used in the tool tip group
  // If a name is supplied, the new button will be named 

  void InsertSeparator
  (
   int	width = 5
   );

  void ToggleItem
  (
   uint	item
   );
  // Try to toggle the given item

  void EnableItem
  (
   uint	item,
   bool	enable
   );
  // enable or disable one of the buttons on the toolbar

  const QToolTipGroup& GetToolTipGroup( void ) const;
  // get the tool tip group associated with this toolbar

private:

  QSize	itsSize;
  // rectangle of pixmap buttons

  QList<QPushButton>	itsButtonList;
  // list of pushbuttons on the toolbar

  QToolTipGroup	itsToolTipGroup;
  // tool tip group for displaying long messages

};


inline void Toolbar::InsertSeparator
(
    int	width
)
{
    itsSize.rwidth() += width;
}


inline const QToolTipGroup& Toolbar::GetToolTipGroup( void ) const
{
    return itsToolTipGroup;
}


#endif // Toolbar_included


