/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/

#include "Toolbar.h"

#include "Toolbar.moc"

#define Inherited QButtonGroup


Toolbar::Toolbar
(
 QWidget*	parent,
 const char*	name
 )
  :
  Inherited( parent, name ),
  itsSize( 3, 0 ),
  itsToolTipGroup( this )
{
  setExclusive( TRUE );
  itsButtonList.setAutoDelete( FALSE );

  setFrameStyle( WinPanel | Raised );

  resize( width(), 32 );
}


Toolbar::~Toolbar()
{
}


uint Toolbar::Insert
(
    const QPixmap&	pixmap,
    const QObject*	receiver,
    const char*		slot,
    const char*		toolTip,
    const char*		longToolTip,
    const char*   name,
    const bool    toggle
)
{
  return Insert( -2, pixmap, receiver, slot, 
                 toolTip, longToolTip, name, toggle );
}

uint Toolbar::Insert
(
 const int       id,
 const QPixmap&	pixmap,
 const QObject*	receiver,
 const char*		slot,
 const char*		toolTip,
 const char*		longToolTip,
 const char*   name,
 const bool    toggle
 )
{
  QPushButton* button = new QPushButton( this, name );
  int retId = insert( button, id );

  button->setPixmap( pixmap );
  button->adjustSize();
  button->move( itsSize.width(), 3 );
  button->setToggleButton( toggle );
  itsSize.rwidth() += button->width();
  itsSize.rheight() = button->height() > itsSize.height() ? 
    button->height() : itsSize.height();

  resize( itsSize.width() + 3, itsSize.height() + 6 );
    
  if( receiver && slot )
  {
    receiver->connect( button, SIGNAL(clicked()), slot );
  }

  if( toolTip )
  {
    if( longToolTip )
    {
	    QToolTip::add( button, toolTip, &itsToolTipGroup, longToolTip );
    }
    else
    {
	    QToolTip::add( button, toolTip );
    }
  }

  itsButtonList.append( button );
  return retId;
}


void Toolbar::EnableItem
(
 uint	item,
 bool	enable
 )
{
  QButton* button = find( item );
  if( button )
  {
    button->setEnabled( enable );
  }
}

void Toolbar::ToggleItem
(
 uint	item
 )
{
  QPushButton* button;

  // Set all buttons off
  for( button = itsButtonList.first();
       button;
       button = itsButtonList.next() )
  {
    button->setOn( FALSE );
  }

  button = (QPushButton *) find( item );
  if( button )
  {
    button->setOn( TRUE );
  }
}



