/*
 * This file modified from sources for imap4 for use
 * in PHP 3
 */
/*
 * Program:   Unix compatibility routines
 *
 * Author:  Mark Crispin
 *      Networks and Distributed Computing
 *      Computing & Communications
 *      University of Washington
 *      Administration Building, AG-44
 *      Seattle, WA  98195
 *      Internet: MRC@CAC.Washington.EDU
 *
 * Date:    14 September 1996
 * Last Edited: 22 October 1996
 *
 * Copyright 1996 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made available
 * "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


/*              DEDICATION

 *  This file is dedicated to my dog, Unix, also known as Yun-chan and
 * Unix J. Terwilliker Jehosophat Aloysius Monstrosity Animal Beast.  Unix
 * passed away at the age of 11 1/2 on September 14, 1996, 12:18 PM PDT, after
 * a two-month bout with cirrhosis of the liver.
 *
 *  He was a dear friend, and I miss him terribly.
 *
 *  Lift a leg, Yunie.  Luv ya forever!!!!
 */

#include "php.h"				/*php specific */
#include "syslog.h"
#include <stdio.h>
#include <fcntl.h>
#include <process.h>

#include "php_win32_globals.h"

void closelog(void)
{
	TSRMLS_FETCH();
	DeregisterEventSource(PW32G(log_source));
	STR_FREE(PW32G(log_header));
	PW32G(log_header) = NULL;
}

/* Emulator for BSD syslog() routine
 * Accepts: priority
 *      message
 *      parameters
 */

void syslog(int priority, const char *message, ...)
{
	va_list args;
	LPTSTR strs[2];
	unsigned short etype;
	char *tmp = NULL;
	TSRMLS_FETCH();

	/* default event source */
	if (!PW32G(log_source))
		openlog("php", LOG_PID, LOG_SYSLOG);

	switch (priority) {			/* translate UNIX type into NT type */
		case LOG_ALERT:
			etype = EVENTLOG_ERROR_TYPE;
			break;
		case LOG_INFO:
			etype = EVENTLOG_INFORMATION_TYPE;
			break;
		default:
			etype = EVENTLOG_WARNING_TYPE;
	}
	va_start(args, message);	/* initialize vararg mechanism */
	vspprintf(&tmp, 0, message, args);	/* build message */
	strs[0] = PW32G(log_header);	/* write header */
	strs[1] = tmp;				/* then the message */
	/* report the event */
	ReportEvent(PW32G(log_source), etype, (unsigned short) priority, 2000, NULL, 2, 0, strs, NULL);
	va_end(args);
	efree(tmp);
}


/* Emulator for BSD openlog() routine
 * Accepts: identity
 *      options
 *      facility
 */

void openlog(const char *ident, int logopt, int facility)
{
	TSRMLS_FETCH();

	if (PW32G(log_source)) {
		closelog();
	}

	STR_FREE(PW32G(log_header));

	PW32G(log_source) = RegisterEventSource(NULL, ident);
	spprintf(&PW32G(log_header), 0, (logopt & LOG_PID) ? "%s[%d]" : "%s", ident, getpid());
}
