
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 
 

#ifndef __PFLOGX_H__
#define __PFLOGX_H__

#define PFLOGX_VERSION		"0.86"
#define XMLFILE_ENCODING	"UTF-8"

#include "Options.h"
#include "LogEntry.h"
#include <vector>

using namespace std;

class cPfLogx
{
public:

	/* Constructor */
	cPfLogx(int argc, char** argv);
	
	/* Main */
	int Main();

protected:

	/* Parse command line */
	enum eParseCmdLineRet
	{
		PARSECMDLINE_CONTINUE,
		PARSECMDLINE_EXIT_FAILURE,
		PARSECMDLINE_EXIT_SUCCESS
	};
	
	enum eParseCmdLineRet ParseCmdLine();


	/* Parse pflog file */
	bool ParseLogFile();

	/* Parse XML file */
	bool ParseXmlFile();
	
	/* Write XML output file */
	bool WriteXmlFile() const;


	/* Display program usage */
	void DisplayUsage() const;

	/* Display program version */
	void DisplayVersion() const;
	

	/* Command line arguments */
	int m_argc;
	char** m_argv;
	
	/* Options */
	cOptions m_options;
	
	/* Entries */
	vector<cLogEntry> m_vectLogEntries;
};

#endif // __PFLOGX_H__
