
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __XMLFILEWRITER_H__
#define __XMLFILEWRITER_H__

#include "LogEntry.h"
#include "LogEntryFormat.h"
#include <iostream>
#include <string>
#include <vector>

using namespace std;

class cXmlFileWriter
{
public:	
	
	/* Constructor */
	cXmlFileWriter(const string& file, const cLogEntryFormat& entryFormat, const vector<cLogEntry>& vectLogEntries);

	/* Write */
	bool Write();
	
	
	/* Get error string (use it when Write() returns false) */
	inline const string& GetErrorString() const
	{
		return m_errorString;
	}



protected:

	/* Check if output is done on stdout */
	inline bool OutputOnStdOut() const
	{
		return (m_file == "-");
	}
	

	/* Open output file */
	bool OpenFile();
	
	/* Write a string to outfile file */
	bool WriteString(const string& str);
	
	/* Close output file */
	bool CloseFile();
	
	
	/* Write header, footer and entry */
	bool WriteHeader();
	bool WriteFooter();
	bool WriteEntry(const cLogEntry& entry);
	
	
	/* Output file name */
	string m_file;

	/* Entry format object */
	cLogEntryFormat m_entryFormat;
	
	/* Log entries */
	vector<cLogEntry> m_vectLogEntries;


	/* Output stream */
	ostream* m_outputStream;
	
	/* Error string */
	string m_errorString;
};


#endif // __XMLFILEWRITER_H__
