
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __XMLFILEPARSER_H__
#define __XMLFILEPARSER_H__

#include "LogEntry.h"
#include "LogEntryParser.h"
#include <expat.h>
#include <stdio.h>
#include <string>
#include <vector>

using namespace std;

class cXmlFileParser
{
public:	

	/* Constructor */
	cXmlFileParser(const string& file, const cLogEntryParser& entryParser);
	
	
	/* Return values for Parse() method */
	enum eParseRet
	{
		PARSE_NO_ERROR=0,
		PARSE_INPUTFILE_OPEN_ERROR,
		PARSE_INPUTFILE_READ_ERROR,
		PARSE_XMLPARSER_INIT_ERROR,
		PARSE_XMLPARSER_PARSE_ERROR,
		PARSE_INPUTFILE_INVALID
	};
	
	/* Parse XML file */
	enum eParseRet Parse();
	
	
	/* Retrieve log entries */
	inline const vector<cLogEntry>& GetLogEntries() const
	{
		return m_vectLogEntries;
	}
		
	/* Get error string (use it when Parse() fails) */
	inline const string& GetErrorString() const
	{
		return m_errorString;
	}
	

protected:

	/* Open input file */
	bool OpenFile();

	/* Close input file */
	bool CloseFile();
	
	/* Parse opened input file */
	enum eParseRet ParseFile();


	/* Initialize XML parser */
	bool InitXmlParser();
	
	/* Release XML parser */
	void ReleaseXmlParser();

	/* XML parser handlers */
	void XmlStartElementHandler(const XML_Char *name, const XML_Char **atts);
	void XmlEndElementHandler(const XML_Char *name);

	/* Parse XML element "log" */
	bool XmlParseLogElement(const XML_Char **atts);

	/* XML parser static handlers */
	static void XmlStartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts);
	static void XmlEndElementHandler(void *userData, const XML_Char *name);


	/* Input file name */
	string m_file;

	/* Entry parser object */
	cLogEntryParser m_entryParser;
	
	
	/* Log entries */
	vector<cLogEntry> m_vectLogEntries;

	/* Input file descriptor */
	int m_inputFileDesc;
	
	/* XML parser */
	XML_Parser m_xmlParser;
	
	/* Type of current element */
	enum eElementType
	{
		XMLELEMENT_ERROR=-1,
		XMLELEMENT_UNKNOWN=0,
		XMLELEMENT_PFLOGX,
		XMLELEMENT_LOGS,
		XMLELEMENT_LOG
		
	} m_xmlElementType;
	
	
	/* Error string */
	string m_errorString;
};

#endif // __XMLFILEPARSER_H__
