
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 

 
#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include <string>
#include <vector>

using namespace std;

class cOptions
{
public:

	/* Constructor */
	cOptions();
	

	/* Get input file */
	inline const string& GetInputFile() const
	{
		return m_inputFile; 
	}
	
	/* Set input file */
	inline void SetInputFile(const string& inputFile)
	{
		m_inputFile=inputFile; 
	}


	/* Get output file */
	inline const string& GetOutputFile() const
	{
		return m_outputFile; 
	}
	
	/* Set output file */
	inline void SetOutputFile(const string& outputFile)
	{
		m_outputFile=outputFile; 
	}


	/* Get action filter */
	inline const vector<u_int8_t>& GetFilterAction() const
	{
		return m_vectFilterAction;
	}

	/* Set action filter */
	inline void SetFilterAction(const vector<u_int8_t>& vectFilter)
	{
		m_vectFilterAction=vectFilter;
	}


	/* Get direction filter */
	inline const vector<u_int8_t>& GetFilterDirection() const
	{
		return m_vectFilterDirection;
	}

	/* Set direction filter */
	inline void SetFilterDirection(const vector<u_int8_t>& vectFilter)
	{
		m_vectFilterDirection=vectFilter;
	}


	/* Get protocol filter */
	inline const vector<u_int8_t>& GetFilterProtocol() const
	{
		return m_vectFilterProtocol;
	}

	/* Set protocol filter */
	inline void SetFilterProtocol(const vector<u_int8_t>& vectFilter)
	{
		m_vectFilterProtocol=vectFilter;
	}


	/* Get interface filter */
	inline const vector<string>& GetFilterInterface() const
	{
		return m_vectFilterInterface;
	}

	/* Set interface filter */
	inline void SetFilterInterface(const vector<string>& vectFilter)
	{
		m_vectFilterInterface=vectFilter;
	}


	/* Get switch to display erroneous packets */
	inline bool GetDisplayErrorsPackets() const
	{
		return m_bDisplayErrorsPackets;
	}
	
	/* Set switch to display erroneous packets */
	inline void SetDisplayErrorsPackets(bool bDisplayErrorsPackets)
	{
		m_bDisplayErrorsPackets=bDisplayErrorsPackets;
	}
	
	
	/* Get switch to sort events in reverse order */
	inline bool GetReverseSort() const
	{
		return m_bReverseSort;
	} 

	/* Set switch to sort events in reverse order */
	inline void SetReverseSort(bool bReverseSort)
	{
		m_bReverseSort=bReverseSort;
	} 
	
	
	/* Get switch to merge events with already existing events */
	inline bool GetMergeEvents() const
	{
		return m_bMergeEvents; 
	}
	
	/* Set switch to merge events with already existing events */
	inline void SetMergeEvents(bool bMergeEvents)
	{
		m_bMergeEvents=bMergeEvents; 
	}
	
	
	/* Output date format */
	enum eDateFormat
	{
		DATEFORMAT_SECONDS,
		DATEFORMAT_HUMAN
	};
	
	/* Get output date format */
	inline enum eDateFormat GetOutDateFormat() const
	{
		return m_outDateFormat;
	}

	/* Set output date format */
	inline void SetOutDateFormat(enum eDateFormat outDateFormat)
	{
		m_outDateFormat=outDateFormat;
	}
	

protected:

	/* Input and output files */
	string m_inputFile, m_outputFile;
	
	/* Filters on action, direction and protocol */
	vector<u_int8_t> m_vectFilterAction, m_vectFilterDirection, m_vectFilterProtocol;
	
	/* Filter on interface */
	vector<string> m_vectFilterInterface;

	/* Switches */
	bool m_bDisplayErrorsPackets, m_bReverseSort, m_bMergeEvents;
	
	/* Output date format */
	enum eDateFormat m_outDateFormat;
};

#endif // __OPTIONS_H__
