
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __LOGENTRYFORMAT_H__
#define __LOGENTRYFORMAT_H__

#include "LogEntry.h"
#include "Options.h"
#include <string>

using namespace std;

class cLogEntryFormat
{
public:

	/* Constructor */
	cLogEntryFormat(const cOptions& options);

	
	/* Format given entry */
	void Format(const cLogEntry& entry);
	
	/* Get time */
	inline const string& GetTime() const
	{
		return m_time;
	} 
	
	/* Get interface name */
	inline const string& GetIfName() const
	{
		return m_ifName;
	} 
	
	/* Get rule number */
	inline const string& GetRuleNumber() const
	{
		return m_ruleNumber;
	}
	
	/* Get action */
	inline const string& GetAction() const
	{
		return m_action;
	} 
	
	/* Get direction */
	inline const string& GetDirection() const
	{
		return m_direction;
	} 
	
	/* Get protocol */
	inline const string& GetProtocol() const
	{
		return m_protocol;
	} 
	
	/* Get destination address */
	inline const string& GetDestAddress() const
	{
		return m_destAddress;
	} 
	
	/* Get source address */
	inline const string& GetSrcAddress() const
	{
		return m_srcAddress;
	} 
	
	/* Get destination port */
	inline const string& GetDestPort() const
	{
		return m_destPort;
	} 
	
	/* Get source port */
	inline const string& GetSrcPort() const
	{
		return m_srcPort;
	} 
	
protected:

	/* Format methods for fields */
	void FormatTime(const cLogEntry& entry);
	void FormatAction(const cLogEntry& entry);
	void FormatRuleNumber(const cLogEntry& entry);
	void FormatDirection(const cLogEntry& entry);
	void FormatProtocol(const cLogEntry& entry);
	void FormatAddresses(const cLogEntry& entry);
	void FormatPorts(const cLogEntry& entry);
	
	/* Reset object */
	void Reset();
	
	
	/* Options */
	cOptions m_options;

	/* String representation of entry fields */
	string m_time, m_ifName, m_ruleNumber, m_action, m_direction, m_protocol, m_destAddress, m_srcAddress, m_destPort, m_srcPort;
};


#endif // __LOGENTRYFORMAT_H__
