
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __ENTRIESFILTER_H__
#define __ENTRIESFILTER_H__

#include "LogEntry.h"
#include "Options.h"
#include <vector>

using namespace std; 

class cEntriesFilter
{
public:

	/* Constructor */
	cEntriesFilter(const vector<cLogEntry>& vectLogEntries, const cOptions& options);

	/* Apply filters */
	void ApplyFilters();
	
	/* Retrieve output entries */
	inline const vector<cLogEntry>& GetEntries() const
	{
		return m_vectOutputEntries;
	}

protected:

	/* Check if given filter is included in filters list */
	template <class T>
	bool IsInFilter(T filter, const vector<T>& vectFilters) const;
	
	/* Structre to compare two cLogEntry objects */
	struct sLogEntryCmp
	{
		bool operator()(const cLogEntry& e1, const cLogEntry& e2) const;
	};
	
	/* Structure to compare time of two cLogEntry objects in ascending order */
	struct sSortLogEntryAsc
	{
		bool operator()(const cLogEntry& e1, const cLogEntry& e2) const;
	};

	/* Structure to compare time of two cLogEntry objects in descending order */
	struct sSortLogEntryDesc
	{
		bool operator()(const cLogEntry& e1, const cLogEntry& e2) const;
	};


	/* Input entries */
	vector<cLogEntry> m_vectInputEntries;

	/* Output entries */
	vector<cLogEntry> m_vectOutputEntries;

	/* Options */
	cOptions m_options;
}; 

#endif // __ENTRIESFILTER_H__
