BOOK = pfe-fth
WORDS = pfe-wordsets.docbook
# WORDS = pfe-words.part
chm : chm-user/$(BOOK).chm

chm-user/$(BOOK).chm : *.dbk *.part ../doc/*.dbk ../TOOL_XSL/*
	$(MAKE) -f ../TOOL_XSL/makefile.chm SEC=user \
               TEK_FILTER_CAT=cat DOC=$(BOOK)

html : html-internal/$(BOOK).tar.gz

html-internal/$(BOOK).tar.gz : *.dbk *.part ../doc/*.dbk ../TOOL_XSL/*
	$(MAKE) -f ../TOOL_XSL/makefile.html SEC=internal \
               TEK_FILTER_CAT=cat DOC=$(BOOK)

htm : pfe-fth.html
pfe-fth.html : *.dbk $(WORDS) ../doc/*.dbk
	test -f dpans-toc.part || echo "" >dpans-toc.part
	xmlto html-nochunks pfe-fth.dbk
	test -s dpans-toc.part || rm dpans-toc.part

htms : index.html
index.html : *dbk $(WORDS) ../doc/*.dbk
	test -f dpans-toc.part || echo "" >dpans-toc.part
	xmlto html pfe-fth.dbk
	test -s dpans-toc.part || rm dpans-toc.part

# check for unresolved internal links in pfe-words master
unresolved : 
	grep "link  linkend" $(WORDS)

# check for errors in syntax to put documentation into source code
check-mforth :
	grep '^[/][*][ ]' ../mforth/*.c \
	| grep '(' \
	| grep -v -e '----' \
	| grep -v -e '====' \
	| grep -v -e '[.][.][.][.][.]'
# known problems SENDME-CR-QUERY defined twice, the badformatted one
# tells about "internal" implementation behaviour.

check-pfe :
	grep '^[/][*][ ]' ../EMUL_PFE/pfe/*.c \
	| grep '(' \
	| grep -v -e '----' \
	| grep -v -e '====' \
	| grep -v -e '[.][.][.][.][.]'

watch-chm :
	/net/guidod/bin/watch " ls -t -l chm-user | head "
watch-html :
	/net/guidod/bin/watch " ls -t -l html-internal | head "

#_______________ making of $(WORDS) :        (note: you need lib pcre!)
EMUL_PFE=..

$(WORDS).xml : $(EMUL_PFE)/pfe/*.c  \
	         wordsets2words.pl # xml-c-pfe-doc
	- test -f ./xml-c-pfe-doc && cat ./xml-c-pfe-doc > ./xml-c-pfe-doc.e
	- test -s ./xml-c-pfe-doc.e || \
	echo '#! /usr/bin/env xml-c-pfe-doc' >./xml-c-pfe-doc.e
	chmod +x ./xml-c-pfe-doc.e
	./xml-c-pfe-doc.e $(EMUL_PFE)/pfe/*.c > pfe-words.xml
	perl ./wordsets2words.pl --nodoctype --indexterm $(DPANS) \
	pfe-words.xml > $@
$(WORDS) : $(WORDS).xml
	test -s $@.xml && cp $@.xml $@

# --prefix=$HOME/$OSTYPE is my usual installplace
MY_EMUL_PFE=/net/guidod/a/pfe
MY_USRLOCAL=/net/guidod/solaris2.6
MY_XMLG=/net/guidod/4/xmlg
XMLG=xmlg
USRLOCAL=/usr/local
MAKES= $(MAKE) -f $(BOOK).mk
xmlgconfigure :
	( cd "$(XMLG)" && sh configure --disable-shared \
        --prefix=$(USRLOCAL) --with-pcre=$(USRLOCAL) \
        --with-pfe=$(EMUL_PFE) )
xmlgmake :
	cd "$(XMLG)" && make
xmlgclean :
	cd "$(XMLG)" && make clean
xmlgcopy :
	test -f "$(XMLG)/bin/xml-c-pfe-doc" && \
	     cp "$(XMLG)/bin/xml-c-pfe-doc" ./xml-c-pfe-doc
	ls -lL xml-c-pfe-doc
xmlgcopy2 :
	test -f "$(XMLG)/doc/pfe/wordsets2words.pl" && \
	     cp "$(XMLG)/doc/pfe/wordsets2words.pl" ./wordsets2words.pl
	ls -lL wordsets2words.pl

xmlg : # my own version: build/copyfrom my guidod homedir parts
	$(MAKES) xmlgconfigure "USRLOCAL=$(MY_USRLOCAL)" "XMLG=$(MY_XMLG)" \
	"EMUL_PFE=$(MY_EMUL_PFE)"
	$(MAKES) xmlgclean "XMLG=$(MY_XMLG)"
	$(MAKES) xmlgmake  "XMLG=$(MY_XMLG)"
	$(MAKES) xmlgcopy  "XMLG=$(MY_XMLG)"
xmlgg : xmlg
	$(MAKES) xmlgcopy2 "XMLG=$(MY_XMLG)"
xmlggcopy :
	$(MAKES) xmlgcopy xmlgcopy2 "XMLG=$(MY_XMLG)"
diff :
	$(MAKES) $(WORDS).xml
	diff -u $(WORDS).xml $(WORDS)

# -----------------------------------------------------------------

# the files in ../doc/*.dbk do use some "CDATA" sections to
# integrate source code examples easily. The xsltproc being
# used in Feb/2003 had a bug however - using xsl:copy to
# put a subtree through into output would treat text-nodes
# the same as cdata-nodes, in other words
#     <screen><![CDATA[  option -f <file>   ]]></screen>
# becomes in the output xml 
#     <screen>           option -f <file>      </screen>
# which makes the next xsltproc in the toolchain to fail for
# the tag mismatch ("</screen> seen but expecting </file>").
#
# As for now, we use a hack in ../TOOL_XSL/makefile.common
# that recognizes the make-variable TEK_FILTER_CAT - if it
# is set then the initial xsl-transformation is dumped and
# replaced with a simple "cat" command. The initial xsl
# transformation would cut out "internal" documentation
# nodes and xsl:copy all the others that should be visible
# according to the SEC-mode given.
#
# This hack should be obsolete when updating to a new 
# xsltproc however. 
