/* $Id: quickreference.java,v 1.6 2001/04/18 09:41:16 tm Exp $
 *
 * PDFlib/PDI client: mini imposition demo
 */

import java.io.*;
import com.pdflib.pdflib;

public class quickreference
{
    public static void main (String argv[]) throws
	OutOfMemoryError, IOException, IllegalArgumentException,
	IndexOutOfBoundsException, ClassCastException, ArithmeticException,
	RuntimeException, InternalError, UnknownError
    {
	int manual, page;
	int font, row, col;
	final int maxrow = 2, maxcol = 2;
	int i, startpage = 122, endpage = 125;
	final float width = 500, height = 770;
	int pageno;
	pdflib p;
	String infile = "../../doc/PDFlib-manual.pdf";

	p = new pdflib();

	if (p.open_file("quickreference.pdf") == -1) {
	    System.err.println("Couldn't open output file.\n");
	    System.exit(1);
	}

	p.set_info("Creator", "quickreference.java");
	p.set_info("Author", "Thomas Merz");
	p.set_info("Title", "imposition demo (Java)");

	manual = p.open_pdi(infile, "", 0);
	if (manual == -1) {
	    System.err.println("Couldn't open input file '" + infile + "'.\n");
	    System.exit(1);
	}

	row = 0;
	col = 0;

	for (pageno = startpage; pageno <= endpage; pageno++) {
	    if (row == 0 && col == 0) {
		p.begin_page(width, height);
		font = p.findfont("Helvetica-Bold", "host", 0);
		p.setfont(font, 18);
		p.set_text_pos(25, height-24);
		p.show("PDFlib 4.0 Quick Reference");
	    }

	    page = p.open_pdi_page(manual, pageno, "");

	    if (page == -1) {
		System.err.println("Couldn't open page " + pageno +
		    " in '" + infile + "'.\n");
		System.exit(1);
	    }

	    p.place_pdi_page(manual, width/maxcol*col,
		    height - (row + 1) * height/maxrow,
		    (float) 1/maxrow, (float) 1/maxrow);
	    p.close_pdi_page(page);

	    col++;
	    if (col == maxcol) {
		col = 0;
		row++;
	    }
	    if (row == maxrow) {
		row = 0;
		p.end_page();
	    }
	}

	// finish the last partial page
	if (row != 0 || col != 0)
	    p.end_page();

	p.close();
	p.close_pdi(manual);
    }
}
