/* $Id: personalize.java,v 1.6 2001/04/18 10:16:13 tm Exp $
 *
 * PDFlib/PDI client: personalization demo
 */

import java.io.*;
import java.text.*;		// DateFormat
import java.util.*;		// Date
import com.pdflib.pdflib;

public class personalize
{
    public static void main (String argv[]) throws
	OutOfMemoryError, IOException, IllegalArgumentException,
	IndexOutOfBoundsException, ClassCastException, ArithmeticException,
	RuntimeException, InternalError, UnknownError
    {
	int form, page, font;
	float width, height;
	pdflib p;
	Date now = new Date();
	DateFormat fulldate = DateFormat.getDateInstance(DateFormat.LONG); 
	String infile = "../../doc/PDFlib-purchase-order.pdf";
	final int col1 = 70, col2 = 335;

	p = new pdflib();

	if (p.open_file("personalize.pdf") == -1) {
	    System.err.println("Couldn't open output file.\n");
	    System.exit(1);
	}

	p.set_info("Creator", "personalize.java");
	p.set_info("Author", "Thomas Merz");
	p.set_info("Title", "PDFlib personalization demo (Java)");

	form = p.open_pdi(infile, "", 0);
	if (form == -1) {
	    System.err.println("Couldn't open input file '" + infile + "'.\n");
	    System.exit(1);
	}

	page = p.open_pdi_page(form, 1, "");
	if (page == -1) {
	    System.err.println("Couldn't open page 1 in '" + infile + "'.\n");
	    System.exit(1);
	}

	font = p.findfont("Helvetica-Bold", "host", 0);

	// get the dimensions of the imported form
	width = p.get_pdi_value("width", form, page, 0);
	height = p.get_pdi_value("height", form, page, 0);

	p.begin_page(width, height);
	p.place_pdi_page(page, 0, 0, 1, 1);
	p.close_pdi_page(page);

	p.setfont(font, 18);
	p.set_value("leading", 24);
	p.set_text_pos(col1, 486);

	p.show("Doublecheck, Inc.");
	p.continue_text("Petra Porst");
	p.continue_text("500, Market St.");
	p.continue_text("94110 San Francisco, CA");
	p.continue_text("");
	p.continue_text("USA");
	p.continue_text("+1/950/123-4567");
	p.continue_text("+1/950/123-4568");
	p.continue_text("");
	p.continue_text("petra@doublecheck.com");

	p.set_text_pos(col2, 152);
	p.continue_text(fulldate.format(now));

	p.end_page();

	p.close();
	p.close_pdi(form);
    }
}
