// $Id: quickreference.cpp,v 1.7 2001/04/18 09:41:16 tm Exp $
//
// PDFlib/PDI client: mini imposition demo
//
#include <stdio.h>
#include <stdlib.h>

#include "pdflib.hpp"

int
main(void)
{
    PDF *p;			// pointer to the PDF class
    int manual, page;
    int font, row, col;
    const int maxrow = 2;
    const int maxcol = 2;
    int i, startpage = 122, endpage = 125;
    const float width = 500, height = 770;
    int pageno;
    const char *infile = "../../doc/PDFlib-manual.pdf";

    p = new PDF();

    if (p->open("quickreference.pdf") == -1) {
	fprintf(stderr, "Error: cannot open PDF file 'quick_reference.pdf'.\n");
	exit(2);
    }

    p->set_info("Creator", "quickreference.cpp");
    p->set_info("Author", "Thomas Merz");
    p->set_info("Title", "mini imposition demo (C++)");

    manual = p->open_pdi(infile, "", 0);
    if (manual == -1) {
	fprintf(stderr, "Couldn't open input file '%s'.\n", infile);
	exit(2);
    }

    row = 0;
    col = 0;

    for (pageno = startpage; pageno <= endpage; pageno++) {
	if (row == 0 && col == 0) {
	    p->begin_page(width, height);
	    font = p->findfont("Helvetica-Bold", "host", 0);
	    p->setfont(font, 18);
	    p->set_text_pos(25, height-24);
	    p->show("PDFlib 4.0 Quick Reference");
	}

	page = p->open_pdi_page(manual, pageno, "");

	if (page == -1) {
	    fprintf(stderr, "Couldn't open page %d in '%s'.\n", pageno, infile);
	    exit(2);
	}

	p->place_pdi_page(manual, width/maxcol*col, height - (row + 1)
			* height/maxrow, (float) 1/maxrow, (float) 1/maxrow);
	p->close_pdi_page(page);

	col++;
	if (col == maxcol) {
	    col = 0;
	    row++;
	}
	if (row == maxrow) {
	    row = 0;
	    p->end_page();
	}
    }

    // finish the last partial page
    if (row != 0 || col != 0)
	p->end_page();

    p->close();
    p->close_pdi(manual);

    return 0;
}
