// $Id: personalize.cpp,v 1.8 2001/04/18 10:16:13 tm Exp $
//
// PDFlib/PDI client: personalization demo
//
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "pdflib.hpp"

int
main(void)
{
    PDF *p;			// pointer to the PDF class
    int		form, page, font;
    float	width, height;
    char *	infile = (char *) "../../doc/PDFlib-purchase-order.pdf";
    const int	col1 = 70;
    const int	col2 = 335;
    time_t	timer;
    struct tm	ltime;
    char	date[100];

    static const char *months[] = {
	"January", "February", "March", "April", "May", "June",
	"July", "August", "September", "October", "November", "December"
    };

    p = new PDF();

    if (p->open("personalize.pdf") == -1) {
	fprintf(stderr, "Error: cannot open PDF file personalize.pdf.\n");
	exit(2);
    }

    p->set_info("Creator", "personalize.cpp");
    p->set_info("Author", "Thomas Merz");
    p->set_info("Title", "PDFlib personalization demo (C++)");

    form = p->open_pdi(infile, "", 0);
    if (form == -1) {
	fprintf(stderr, "Couldn't open input file '%s'.\n", infile);
	exit(2);
    }

    page = p->open_pdi_page(form, 1, "");
    if (page == -1) {
	fprintf(stderr, "Couldn't open page 1 in '%s'.\n", infile);
	exit(2);
    }

    font = p->findfont("Helvetica-Bold", "host", 0);

    // get the dimensions of the imported form
    width = p->get_pdi_value("width", form, page, 0);
    height = p->get_pdi_value("height", form, page, 0);

    p->begin_page(width, height);
    p->place_pdi_page(page, 0, 0, 1, 1);
    p->close_pdi_page(page);

    p->setfont(font, 18);
    p->set_value("leading", 24);
    p->set_text_pos(col1, 486);

    p->show("Doublecheck, Inc.");
    p->continue_text("Petra Porst");
    p->continue_text("500, Market St.");
    p->continue_text("94110 San Francisco, CA");
    p->continue_text("");
    p->continue_text("USA");
    p->continue_text("+1/950/123-4567");
    p->continue_text("+1/950/123-4568");
    p->continue_text("");
    p->continue_text("petra@doublecheck.com");

    time(&timer);
    ltime = *localtime(&timer);
    sprintf(date, "%s %d, %d",
		months[ltime.tm_mon], ltime.tm_mday, ltime.tm_year + 1900);
    p->set_text_pos(col2, 152);
    p->continue_text(date);

    p->end_page();
    p->close();
    p->close_pdi(form);

    return 0;
} // main
