/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2001 PDFlib GmbH and Thomas Merz. All rights reserved. |
 +---------------------------------------------------------------------------+
 |    This software is NOT in the public domain.  It can be used under two   |
 |    substantially different licensing terms:                               |
 |                                                                           |
 |    The commercial license is available for a fee, and allows you to       |
 |    - ship a commercial product based on PDFlib                            |
 |    - implement commercial Web services with PDFlib                        |
 |    - distribute (free or commercial) software when the source code is     |
 |      not made available                                                   |
 |    Details can be found in the file PDFlib-license.pdf.                   |
 |                                                                           |
 |    The "Aladdin Free Public License" doesn't require any license fee,     |
 |    and allows you to                                                      |
 |    - develop and distribute PDFlib-based software for which the complete  |
 |      source code is made available                                        |
 |    - redistribute PDFlib non-commercially under certain conditions        |
 |    - redistribute PDFlib on digital media for a fee if the complete       |
 |      contents of the media are freely redistributable                     |
 |    Details can be found in the file aladdin-license.pdf.                  |
 |                                                                           |
 |    These conditions extend to ports to other programming languages.       |
 |    PDFlib is distributed with no warranty of any kind. Commercial users,  |
 |    however, will receive warranty and support statements in writing.      |
 *---------------------------------------------------------------------------*/

// $Id: pdflib.hpp,v 1.14 2001/04/02 11:45:28 york Exp $
//
// C++ wrapper for PDFlib
//
//

#ifndef PDFLIB_HPP
#define PDFLIB_HPP

// Uncomment this if your compiler doesn't support proper bool handling
//#define PDF_BROKEN_BOOL

// Add your compiler here if it doesn't like "using namespace std" for
// proper handling of ANSI C++ strings
#ifndef __GNUC__
#define PDF_NEED_NAMESPACE
#endif

#ifdef PDF_BROKEN_BOOL
    #define bool	int
#endif

// If ANSI C++ strings don't work we revert to plain old C char *
#ifndef PDF_BROKEN_STRINGS
    #include <string>

    // VC++ needs this to recognize the string class, but gcc doesn't
    // understand it...
    #ifdef PDF_NEED_NAMESPACE
	using namespace std;
    #endif

    #define pdfstring	string
#else
    #define pdfstring	const char *
#endif

// We use PDF as a C++ class name, therefore hide the actual C struct
// name for PDFlib usage with C++.

#define PDF PDF_c
#include "pdflib.h"
#undef PDF


// The C++ class wrapper for PDFlib

class PDF {
public:
    PDF(errorproc_t errorproc = NULL,
	allocproc_t allocproc = NULL,
	reallocproc_t reallocproc = NULL,
	freeproc_t freeproc = NULL,
	void *opaque = NULL);
    ~PDF();

    void * get_opaque();
    static int get_majorversion();
    static int get_minorversion();

    // Overloaded generic open and close methods
    int  open(pdfstring filename);
    int  open(FILE *fp);
    void open(writeproc_t writeproc);

    void close();

    const char *get_buffer(long *size);

    void begin_page(float width, float height);
    void end_page();
    void set_parameter(pdfstring key, pdfstring value);
    pdfstring get_parameter(pdfstring key, float mod);
    float get_value(pdfstring key, float mod);
    void set_value(pdfstring key, float value);
    void show(pdfstring text);

// If ANSI C++ strings are not available, we need the old-style C
// functions for dealing with strings with embedded null characters
#ifdef PDF_BROKEN_STRINGS
    void show2(pdfstring text, int len);
    void show_xy2(pdfstring text, int len, float x, float y);
    void continue_text2(pdfstring text, int len);
    float stringwidth2(pdfstring text, int len, int font, float size);
#endif
    void show_xy(pdfstring text, float x, float y);
    void continue_text(pdfstring text);
    int show_boxed(pdfstring text, float left, float top,
	float width, float height, pdfstring hmode, pdfstring reserved);
    void set_text_pos(float x, float y);

    float stringwidth(pdfstring text, int font, float size);

    int  findfont(pdfstring fontname, pdfstring encoding, int embed);
    void setfont(int font, float fontsize);
    void save();
    void restore();
    void translate(float tx, float ty);
    void scale(float sx, float sy);
    void rotate(float phi);
    void skew(float alpha, float beta);
    void concat(float a, float b, float c, float d, float e, float f);
    void setdash(float b, float w);
    void setpolydash(float *darray, int length);
    void setflat(float flat);
    void setlinejoin(int join);
    void setlinecap(int cap);
    void setmiterlimit(float miter);
    void setlinewidth(float width);
    void moveto(float x, float y);
    void lineto(float x, float y);
    void curveto(float x1, float y1, float x2, float y2, float x3, float y3);
    void circle(float x, float y, float r);
    void arc(float x, float y, float r, float alpha1, float alpha2);
    void arcn(float x, float y, float r, float alpha1, float alpha2);
    void rect(float x, float y, float width, float height);
    void closepath();
    void stroke();
    void closepath_stroke();
    void fill();
    void fill_stroke();
    void closepath_fill_stroke();
    void clip();
    void endpath();
    void setgray_fill(float g);
    void setgray_stroke(float g);
    void setgray(float g);
    void setrgbcolor_fill(float red, float green, float blue);
    void setrgbcolor_stroke(float red, float green, float blue);
    void setrgbcolor(float red, float green, float blue);
    int begin_template(float width, float height);
    void end_template();
    void place_image(int image, float x, float y, float scale);
    int open_image(pdfstring type, pdfstring source, const char *data, long len,
    	int width, int height, int components, int bpc, pdfstring params);
    int open_image_file(pdfstring type, pdfstring filename,
    	pdfstring stringparam, int intparam);
    void close_image(int image);
    int open_CCITT(pdfstring filename, int width, int height,
    	bool BitReverse, int K, bool BlackIs1);
    int add_bookmark(pdfstring text, int parent, bool open);
    void set_info(pdfstring key, pdfstring value);
    void attach_file(float llx, float lly, float urx, float ury,
    	pdfstring filename, pdfstring description, pdfstring author,
	pdfstring mimetype, pdfstring icon);
    void add_note(float llx, float lly, float urx, float ury,
    	pdfstring contents, pdfstring title, pdfstring icon, bool open);
    void add_pdflink(float llx, float lly, float urx, float ury,
    	pdfstring filename, int page, pdfstring dest);
    void add_launchlink(float llx, float lly, float urx, float ury,
    	pdfstring filename);
    void add_locallink(float llx, float lly, float urx, float ury,
    	int page, pdfstring dest);
    void add_weblink(float llx, float lly, float urx, float ury, pdfstring url);

    void set_border_style(pdfstring style, float width);
    void set_border_color(float red, float green, float blue);
    void set_border_dash(float d1, float d2);

    int open_pdi(pdfstring filename, pdfstring stringparam, int intparam);
    void close_pdi(int doc);
    int open_pdi_page(int doc, int page, pdfstring label);
    void place_pdi_page(int page, float x, float y, float sx, float sy);
    void close_pdi_page(int page);
    pdfstring get_pdi_parameter(pdfstring key, int doc, int page, int index,
	int *len);
    float get_pdi_value(pdfstring key, int doc, int page, int index);

    int begin_pattern(float width, float height, float xstep, float ystep,
	int painttype);
    void end_pattern();
    int makespotcolor(pdfstring spotname, int len);
    void setcolor(pdfstring type, pdfstring colorspace,
	float c1, float c2, float c3, float c4);
    void add_thumbnail(int image);
    void initgraphics();
    void setmatrix(float a, float b, float c, float d, float e, float f);

private:
    PDF_c *p;
};

#endif	// PDFLIB_HPP
