/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2001 PDFlib GmbH and Thomas Merz. All rights reserved. |
 +---------------------------------------------------------------------------+
 |    This software is NOT in the public domain.  It can be used under two   |
 |    substantially different licensing terms:                               |
 |                                                                           |
 |    The commercial license is available for a fee, and allows you to       |
 |    - ship a commercial product based on PDFlib                            |
 |    - implement commercial Web services with PDFlib                        |
 |    - distribute (free or commercial) software when the source code is     |
 |      not made available                                                   |
 |    Details can be found in the file PDFlib-license.pdf.                   |
 |                                                                           |
 |    The "Aladdin Free Public License" doesn't require any license fee,     |
 |    and allows you to                                                      |
 |    - develop and distribute PDFlib-based software for which the complete  |
 |      source code is made available                                        |
 |    - redistribute PDFlib non-commercially under certain conditions        |
 |    - redistribute PDFlib on digital media for a fee if the complete       |
 |      contents of the media are freely redistributable                     |
 |    Details can be found in the file aladdin-license.pdf.                  |
 |                                                                           |
 |    These conditions extend to ports to other programming languages.       |
 |    PDFlib is distributed with no warranty of any kind. Commercial users,  |
 |    however, will receive warranty and support statements in writing.      |
 *---------------------------------------------------------------------------*/

// $Id: pdflib.cpp,v 1.13 2001/04/02 11:45:28 york Exp $
//
// Implementation of C++ wrapper for PDFlib
//
//

#include "pdflib.hpp"

// If we don't have ANSI C++ strings we do it the old way.
#ifdef PDF_BROKEN_STRINGS
    #define CHAR(s)	(char const *)(s)
#else
    #define CHAR(s)	s.c_str()
#endif

PDF::PDF(
    errorproc_t errorproc,
    allocproc_t allocproc,
    reallocproc_t reallocproc,
    freeproc_t freeproc,
    void *opaque)
{
    PDF_boot();
    p = ::PDF_new2(errorproc, allocproc, reallocproc, freeproc, opaque);

    if (p)
	PDF_set_parameter(p, "binding", "C++");
}

PDF::~PDF()
{
    ::PDF_delete(p);
    ::PDF_shutdown();
}

void *
PDF::get_opaque()
{
    return ::PDF_get_opaque(p);
}

int
PDF::get_majorversion()
{
    return ::PDF_get_majorversion();
}

int
PDF::get_minorversion()
{
    return ::PDF_get_minorversion();
}

int
PDF::open(pdfstring filename)
{
    return ::PDF_open_file(p, CHAR(filename));
}

int
PDF::open(FILE *fp)
{
    return ::PDF_open_fp(p, fp);
}

void
PDF::open(writeproc_t writeproc)
{
    ::PDF_open_mem(p, writeproc);
}

void
PDF::close()
{
    ::PDF_close(p);
}

const char *
PDF::get_buffer(long *size)
{
    return ::PDF_get_buffer(p, size);
}

void
PDF::begin_page(float width, float height)
{
    ::PDF_begin_page(p, width, height);
}

void
PDF::end_page()
{
    ::PDF_end_page(p);
}

void
PDF::set_parameter(pdfstring key, pdfstring value)
{
    ::PDF_set_parameter(p, CHAR(key), CHAR(value));
}

pdfstring
PDF::get_parameter(pdfstring key, float mod)
{
    return ::PDF_get_parameter(p, CHAR(key), mod);
}

float
PDF::get_value(pdfstring key, float mod)
{
    return ::PDF_get_value(p, CHAR(key), mod);
}

void
PDF::set_value(pdfstring key, float value)
{
    ::PDF_set_value(p, CHAR(key), value);
}

#ifdef PDF_BROKEN_STRINGS

void
PDF::show2(pdfstring text, int len)
{
    ::PDF_show2(p, CHAR(text), len);
}

void
PDF::show_xy2(pdfstring text, int len, float x, float y)
{
    ::PDF_show_xy2(p, CHAR(text), len, x, y);
}

void
PDF::continue_text2(pdfstring text, int len)
{
    ::PDF_continue_text2(p, CHAR(text), len);
}

float
PDF::stringwidth2(pdfstring text, int len, int font, float size)
{
    return ::PDF_stringwidth2(p, CHAR(text), len, font, size);
}

#endif // PDF_BROKEN_STRINGS

void
PDF::show(pdfstring text)
{
#ifdef PDF_BROKEN_STRINGS
    ::PDF_show(p, CHAR(text));
#else
    ::PDF_show2(p, text.c_str(), (int) text.size());
#endif
}

void
PDF::show_xy(pdfstring text, float x, float y)
{
#ifdef PDF_BROKEN_STRINGS
    ::PDF_show_xy(p, CHAR(text), x, y);
#else
    ::PDF_show_xy2(p, text.c_str(), (int) text.size(), x, y);
#endif
}

void
PDF::continue_text(pdfstring text)
{
#ifdef PDF_BROKEN_STRINGS
    ::PDF_continue_text(p, CHAR(text));
#else
    ::PDF_continue_text2(p, text.c_str(), (int) text.size());
#endif
}

int
PDF::show_boxed(pdfstring text, float left, float top,
    float width, float height, pdfstring hmode, pdfstring reserved)
{
    return ::PDF_show_boxed(p, CHAR(text), left, top, width, height,
	    CHAR(hmode), CHAR(reserved));
}

void
PDF::set_text_pos(float x, float y)
{
    ::PDF_set_text_pos(p, x, y);
}

float
PDF::stringwidth(pdfstring text, int font, float size)
{
#ifdef PDF_BROKEN_STRINGS
    return ::PDF_stringwidth(p, CHAR(text), font, size);
#else
    return ::PDF_stringwidth2(p, text.c_str(), (int) text.size(), font, size);
#endif
}

int
PDF::findfont(pdfstring fontname, pdfstring encoding, int embed)
{
    return ::PDF_findfont(p, CHAR(fontname), CHAR(encoding), embed);
}

void
PDF::setfont(int font, float fontsize)
{
    ::PDF_setfont(p, font, fontsize);
}

void
PDF::save()
{
    ::PDF_save(p);
}

void
PDF::restore()
{
    ::PDF_restore(p);
}

void
PDF::translate(float tx, float ty)
{
    ::PDF_translate(p, tx, ty);
}

void
PDF::scale(float sx, float sy)
{
    ::PDF_scale(p, sx, sy);
}

void
PDF::rotate(float phi)
{
    ::PDF_rotate(p, phi);
}

void
PDF::skew(float alpha, float beta)
{
    ::PDF_skew(p, alpha, beta);
}

void
PDF::concat(float a, float b, float c, float d, float e, float f)
{
    ::PDF_concat(p, a, b, c, d, e, f);
}

void
PDF::setdash(float b, float w)
{
    ::PDF_setdash(p, b, w);
}

void
PDF::setpolydash(float *darray, int length)
{
    ::PDF_setpolydash(p, darray, length);
}

void
PDF::setflat(float flat)
{
    ::PDF_setflat(p, flat);
}

void
PDF::setlinejoin(int join)
{
    ::PDF_setlinejoin(p, join);
}

void
PDF::setlinecap(int cap)
{
    ::PDF_setlinecap(p, cap);
}

void
PDF::setmiterlimit(float miter)
{
    ::PDF_setmiterlimit(p, miter);
}

void
PDF::setlinewidth(float width)
{
    ::PDF_setlinewidth(p, width);
}

void
PDF::moveto(float x, float y)
{
    ::PDF_moveto(p, x, y);
}

void
PDF::lineto(float x, float y)
{
    ::PDF_lineto(p, x, y);
}

void
PDF::curveto(float x1, float y1, float x2, float y2, float x3, float y3)
{
    ::PDF_curveto(p, x1, y1, x2, y2, x3, y3);
}

void
PDF::circle(float x, float y, float r)
{
    ::PDF_circle(p, x, y, r);
}

void
PDF::arc(float x, float y, float r, float alpha1, float alpha2)
{
    ::PDF_arc(p, x, y, r, alpha1, alpha2);
}

void
PDF::arcn(float x, float y, float r, float alpha1, float alpha2)
{
    ::PDF_arcn(p, x, y, r, alpha1, alpha2);
}

void
PDF::rect(float x, float y, float width, float height)
{
    ::PDF_rect(p, x, y, width, height);
}

void
PDF::closepath()
{
    ::PDF_closepath(p);
}

void
PDF::stroke()
{
    ::PDF_stroke(p);
}

void
PDF::closepath_stroke()
{
    ::PDF_closepath_stroke(p);
}

void
PDF::fill()
{
    ::PDF_fill(p);
}

void
PDF::fill_stroke()
{
    ::PDF_fill_stroke(p);
}

void
PDF::closepath_fill_stroke()
{
    ::PDF_closepath_fill_stroke(p);
}

void
PDF::clip()
{
    ::PDF_clip(p);
}

void
PDF::endpath()
{
    ::PDF_endpath(p);
}

void
PDF::setgray_fill(float g)
{
    ::PDF_setcolor(p, "fill", "gray", g, 0, 0, 0);
}

void
PDF::setgray_stroke(float g)
{
    ::PDF_setcolor(p, "stroke", "gray", g, 0, 0, 0);
}

void
PDF::setgray(float g)
{
    ::PDF_setcolor(p, "both", "gray", g, 0, 0, 0);
}

void
PDF::setrgbcolor_fill(float red, float green, float blue)
{
    ::PDF_setcolor(p, "fill", "rgb", red, green, blue, 0);
}

void
PDF::setrgbcolor_stroke(float red, float green, float blue)
{
    ::PDF_setcolor(p, "stroke", "rgb", red, green, blue, 0);
}

void
PDF::setrgbcolor(float red, float green, float blue)
{
    ::PDF_setcolor(p, "both", "rgb", red, green, blue, 0);
}

int
PDF::begin_template(float width, float height)
{
    return ::PDF_begin_template(p, width, height);
}

void
PDF::end_template()
{
    ::PDF_end_template(p);
}

void
PDF::place_image(int image, float x, float y, float scale)
{
    ::PDF_place_image(p, image, x, y, scale);
}

int
PDF::open_image(pdfstring type, pdfstring source, const char *data,
    long len, int width, int height, int components, int bpc, pdfstring params)
{
    return ::PDF_open_image(p, CHAR(type), CHAR(source), data, len,
    	width, height, components, bpc, CHAR(params));
}

void
PDF::close_image(int image)
{
    ::PDF_close_image(p, image);
}

int
PDF::open_image_file(pdfstring type, pdfstring filename,
    pdfstring stringparam, int intparam)
{
    return ::PDF_open_image_file(p, CHAR(type), CHAR(filename),
    	CHAR(stringparam), intparam);
}

int
PDF::open_CCITT(pdfstring filename, int width, int height, bool BitReverse,
    int K, bool BlackIs1)
{
    return ::PDF_open_CCITT(p, CHAR(filename), width, height, BitReverse,
	K,BlackIs1);
}

int
PDF::add_bookmark(pdfstring text, int parent, bool open)
{
    return ::PDF_add_bookmark(p, CHAR(text), parent, open);
}

void
PDF::set_info(pdfstring key, pdfstring value)
{
    ::PDF_set_info(p, CHAR(key), CHAR(value));
}

void
PDF::attach_file(float llx, float lly, float urx, float ury,
    pdfstring filename, pdfstring description, pdfstring author,
    pdfstring mimetype, pdfstring icon)
{
    ::PDF_attach_file(p, llx, lly, urx, ury, CHAR(filename), CHAR(description),
    		CHAR(author), CHAR(mimetype), CHAR(icon));
}

void
PDF::add_note(float llx, float lly, float urx, float ury, pdfstring contents,
    pdfstring title, pdfstring icon, bool open)
{
    ::PDF_add_note(p, llx, lly, urx, ury, CHAR(contents),
    	CHAR(title), CHAR(icon), open);
}

void
PDF::add_pdflink(float llx, float lly, float urx, float ury,
    pdfstring filename, int page, pdfstring dest)
{
    ::PDF_add_pdflink(p, llx, lly, urx, ury, CHAR(filename), page, CHAR(dest));
}

void
PDF::add_launchlink(float llx, float lly, float urx, float ury,
    pdfstring filename)
{
    ::PDF_add_launchlink(p, llx, lly, urx, ury, CHAR(filename));
}

void
PDF::add_locallink(float llx, float lly, float urx, float ury, int page,
    pdfstring dest)
{
    ::PDF_add_locallink(p, llx, lly, urx, ury, page, CHAR(dest));
}

void
PDF::add_weblink(float llx, float lly, float urx, float ury, pdfstring url)
{
    ::PDF_add_weblink(p, llx, lly, urx, ury, CHAR(url));
}

void
PDF::set_border_style(pdfstring style, float width)
{
    ::PDF_set_border_style(p, CHAR(style), width);
}

void
PDF::set_border_color(float red, float green, float blue)
{
    ::PDF_set_border_color(p, red, green, blue);
}

void
PDF::set_border_dash(float d1, float d2)
{
    ::PDF_set_border_dash(p, d1, d2);
}

int
PDF::open_pdi(pdfstring filename, pdfstring stringparam, int intparam)
{
    return ::PDF_open_pdi(p, CHAR(filename), CHAR(stringparam), intparam);
}

void
PDF::close_pdi(int doc)
{
    ::PDF_close_pdi(p, doc);
}

int
PDF::open_pdi_page(int doc, int page, pdfstring label)
{
    return ::PDF_open_pdi_page(p, doc, page, CHAR(label));
}

void
PDF::place_pdi_page(int page, float x, float y, float sx, float sy)
{
    ::PDF_place_pdi_page(p, page, x, y, sx, sy);
}

void
PDF::close_pdi_page(int page)
{
    ::PDF_close_pdi_page(p, page);
}

pdfstring
PDF::get_pdi_parameter(pdfstring key, int doc, int page, int index, int *len)
{
    return ::PDF_get_pdi_parameter(p, CHAR(key), doc, page, index, len);
}

float
PDF::get_pdi_value(pdfstring key, int doc, int page, int index)
{
    return ::PDF_get_pdi_value(p, CHAR(key), doc, page, index);
}

int
PDF::begin_pattern(float width, float height, float xstep, float ystep,
    int painttype)
{
    return ::PDF_begin_pattern(p, width, height, xstep, ystep, painttype);
}

void
PDF::end_pattern()
{
    ::PDF_end_pattern(p);
}

int
PDF::makespotcolor(pdfstring spotname, int len)
{
    return ::PDF_makespotcolor(p, CHAR(spotname), len);
}

void
PDF::setcolor(pdfstring type, pdfstring colorspace,
    float c1, float c2, float c3, float c4)
{
    ::PDF_setcolor(p, CHAR(type), CHAR(colorspace), c1, c2, c3, c4);
}

void
PDF::add_thumbnail(int image)
{
    ::PDF_add_thumbnail(p, image);
}

void
PDF::initgraphics()
{
    ::PDF_initgraphics(p);
}

void
PDF::setmatrix(float a, float b, float c, float d, float e, float f)
{
    ::PDF_setmatrix(p, a, b, c, d, e, f);
}
