/******************************************************************

            Title  : pcscdaemon.c
            Package: PC/SC Lite
            Author : David Corcoran
            Date   : 10/24/99
	    License: Copyright (C) 1999 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This is the main pcscd daemon.

********************************************************************/

#include <time.h>
#include <wintypes.h>
#include <pcsclite.h>
#include <winscard_msg.h>
#include <winscard_svc.h>
#include <sys_generic.h>
#include <thread_generic.h>
#include <hotplug.h>
#include <syslog.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <stdio.h>
#include <unistd.h>

/* Some internal functions */
void SVCServiceRunLoop();
void SVCClientCleanup( psharedSegmentMsg );

extern int errno;

PCSCLITE_MUTEX usbNotifierMutex;

/* Cleans up messages still on the queue
   when a client dies
*/
void SVCClientCleanup( psharedSegmentMsg msgStruct ) {
  /* May be implemented in future releases */
}

/* The Message Queue Listener function */
void SVCServiceRunLoop() {

  char errMessage[200];
  sharedSegmentMsg msgStruct;        
  int currHandle, rsp;  
    
  currHandle=0, rsp=0;


  /* Initialize the comm structure */
  rsp = SHMInitializeCommonSegment();

  if ( rsp == -1 ) {
    DebugLogA("SVCServiceRunLoop: Error initializing pcscd.\n",
	      __FILE__, __LINE__);
    SYS_Exit(-1);
  }

  /* Solaris sends a SIGALRM and it is annoying */
 
  signal(SIGALRM, SIG_IGN);
  signal(SIGPIPE, SIG_IGN);

  /* This function always returns zero */
  rsp = SYS_MutexInit(&usbNotifierMutex);

  /* Set up the search for USB/PCMCIA devices */
  HPSearchHotPluggables();

  while(1) {

    switch (SHMProcessEvents(&msgStruct, 0)) {

    case 0:
      if ( msgStruct.mtype == CMD_CLIENT_DIED ) {
	/* Clean up the dead client */
	SYS_MutexLock(&usbNotifierMutex);
	MSGCleanupClient( &msgStruct ); 
	SYS_MutexUnLock(&usbNotifierMutex);
	snprintf(errMessage, sizeof(errMessage), "%s%d%s",
		 "SVCServiceRun: Client ", msgStruct.request_id,
		 " has disappeared.\n" );
#ifdef PCSC_DEBUG
	DebugLogA(errMessage, __FILE__, __LINE__);
#endif
      } else {
	continue;
      }

      break;

    case 1:
	if ( msgStruct.mtype == CMD_FUNCTION ) {
	  /* Command must be found */
	  SYS_MutexLock(&usbNotifierMutex);
	  MSGFunctionDemarshall( &msgStruct );
	  rsp = SHMMessageSend( &msgStruct, msgStruct.request_id, 0 );
	  SYS_MutexUnLock(&usbNotifierMutex);
	} else {
	  continue;
	}

	break;

    case -1:
#ifdef PCSC_DEBUG
	DebugLogA("SVCServiceRun: Error in ProcessEvents.\n", 
		  __FILE__, __LINE__);
#endif
	break;

    default:
      break;;
    }
  }
}

int main(int argc, char **argv) {
  
  int rv;
  char *newReaderConfig;

  rv = 0; newReaderConfig=0;

  /* Handle any command line arguments */
  if ( argc == 2 && (strcmp(argv[1], "-v") == 0) ) {
    printf("pcsc-lite version: %s <corcoran@linuxnet.com>\n",
           PCSCLITE_VERSION_NUMBER);
    return 0;
  } else if ( argc == 2 && (strcmp(argv[1], "-help") == 0) ) {
    printf("pcscd -v       - Display version and exit\n");
    printf("pcscd -c file  - New path to reader.conf\n");
    printf("pcscd -help    - This help menu\n");
    return 0;
  } else if ( argc == 3 && (strcmp(argv[1], "-c") == 0) ) {
    DebugLogC("main: Using new config file: %s\n", argv[2],
	      __FILE__, __LINE__);
    newReaderConfig = argv[2];
  } else if ( argc == 1 ) {
    /* All OK Here */
  } else {
    printf("pcsc-lite: Invalid arguments, try -help \n");
    return 1;
  }

#ifdef USE_DAEMON
  /* standard daemonizing actions */
#ifndef HAVE_DAEMON
  switch (fork()) {
    case -1:
      return (-1);
    case 0:
      break;
    default:
      return (0);
  }
  close(0);
  close(1);
  close(2);
  chdir("/");
#else
  daemon( 0, 0 );
#endif
#endif

  /* Create the /tmp/pcsc directory and chmod it */
  rv = SYS_Mkdir("/tmp/pcsc", S_ISVTX | S_IRWXO | S_IRWXG | S_IRWXU );
#ifdef PCSC_DEBUG
  if ( rv != 0 ) {
    DebugLogC("main: Cannot create /tmp/pcsc: %s\n", strerror(errno),
	      __FILE__, __LINE__);
  }
#endif

  rv = SYS_Chmod("/tmp/pcsc", S_ISVTX | S_IRWXO | S_IRWXG | S_IRWXU );
#ifdef PCSC_DEBUG
  if ( rv != 0 ) {
    DebugLogC("main: Cannot chmod /tmp/pcsc: %s\n", strerror(errno),
	      __FILE__, __LINE__);
  }
#endif

  /* Allocate memory for reader structures     */
  RFAllocateReaderSpace( PCSCLITE_MAX_CONTEXTS );

  /* Grab the information from the reader.conf */    
  if ( newReaderConfig ) {
    DBUpdateReaders ( newReaderConfig );
  } else {
    DBUpdateReaders ( PCSCLITE_READER_CONFIG );
  }

  /* Set the default globals                   */
  g_rgSCardT0Pci.dwProtocol  = SCARD_PROTOCOL_T0;
  g_rgSCardT1Pci.dwProtocol  = SCARD_PROTOCOL_T1;  
  g_rgSCardRawPci.dwProtocol = SCARD_PROTOCOL_RAW;
  
  DebugLogA("main: PC/SC Lite Daemon Ready.\n", __FILE__, __LINE__);
  
  SVCServiceRunLoop();
#ifdef USE_SYSLOG
  syslog( LOG_ERR, "pcscdaemon.c: main: SVCServiceRunLoop returned\n" );
#else
  fprintf(stderr, "pcscdaemon.c: main: SVCServiceRunLoop returned\n");
#endif
  return 1;
}
