/******************************************************************

	MUSCLE SmartCard Development ( http://www.linuxnet.com )
	    Title  : debuglog.c
	    Package: pcsc lite
            Author : David Corcoran
            Date   : 7/27/99
	    License: Copyright (C) 1999 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This handles debugging. 
	            

********************************************************************/

#include <wintypes.h>
#include <pcsclite.h>
#include <debuglog.h>
#include <syslog.h>
#include <stdio.h>

static LONG lSuppress = DEBUGLOG_LOG_ENTRIES;

void DebugLogA( LPCSTR pcMessage, LPCSTR pcFile, LONG liLine ) {

  if ( lSuppress == DEBUGLOG_LOG_ENTRIES ) {
#ifdef	USE_SYSLOG
    syslog( LOG_DEBUG, "%15s %3d: %s", pcFile, (int)liLine, pcMessage );
#else
    printf("%15s %3d: %s", pcFile, (int)liLine, pcMessage);
#endif
  }

} 

void DebugLogB( LPCSTR pcFormat, LONG liValue, LPCSTR pcFile, LONG liLine ) {

  char pcBuffer[150];

  if ( lSuppress == DEBUGLOG_LOG_ENTRIES ) {
    sprintf(pcBuffer, "%15s %3d: %s", pcFile, (int)liLine, pcFormat );
#ifdef	USE_SYSLOG
    syslog( LOG_DEBUG, pcBuffer, liValue );
#else
    printf(pcBuffer, liValue);
#endif
  }

}

void DebugLogC( LPCSTR pcFormat, LPCSTR pcMessage, LPCSTR pcFile, 
		LONG liLine ) {

  char pcBuffer[150];

  if ( lSuppress == DEBUGLOG_LOG_ENTRIES ) {
    sprintf(pcBuffer, "%15s %3d: %s", pcFile, (int)liLine, pcFormat );
#ifdef  USE_SYSLOG
    syslog( LOG_DEBUG, pcBuffer, pcMessage );
#else
    printf(pcBuffer, pcMessage);
#endif
  }

}

void DebugLogD( LPCSTR pcFormat, PUCHAR pucData, LONG liLength, 
		LPCSTR pcFile, LONG liLine ) {

  int i;
  char pcBuffer[150];
  char *tmpBuffer;
  /* tmpBuffer = (char *)malloc( ( 4+liLength ) * sizeof( PUCHAR ) ); */

  if ( lSuppress == DEBUGLOG_LOG_ENTRIES ) {
    sprintf(pcBuffer, "%15s %3d: %s", pcFile, (int)liLine, pcFormat );
#ifdef  USE_SYSLOG
    tmpBuffer = (char *)malloc( liLength*3 + 1); 
    syslog( LOG_DEBUG, pcBuffer, pcFormat );
    for (i=0; i < liLength; i++) {
      /* sprintf( tmpBuffer, "%x ", pucData[i] ); */
      sprintf( tmpBuffer + i*3, "%02X ", pucData[i] );

    } 
    /*    sprintf( tmpBuffer, "\n" ); */
    syslog( LOG_DEBUG, tmpBuffer );
    free( tmpBuffer );
#else
    printf(pcBuffer, pcFormat);
    for (i=0; i < liLength; i++) {
      printf("%x ", pucData[i]);
    } printf("\n");
#endif
  }

}

void DebugLogSuppress( LONG lSType ) {
  lSuppress = lSType;
}

LPSTR pcsc_stringify_error ( LONG Error ) {

  static char strError[75];

  switch ( Error ) {
  case SCARD_S_SUCCESS:
    strcpy(strError, "Command successful.");
    break;
  case SCARD_E_CANCELLED:
    strcpy(strError, "Command cancelled.");
    break;
  case SCARD_E_CANT_DISPOSE:
   strcpy(strError, "Cannot dispose handle.");
    break;
  case SCARD_E_INSUFFICIENT_BUFFER:
   strcpy(strError, "Insufficient buffer.");
    break;
  case SCARD_E_INVALID_ATR:
   strcpy(strError, "Invalid ATR.");
    break;
  case SCARD_E_INVALID_HANDLE:
   strcpy(strError, "Invalid handle.");
    break;
  case SCARD_E_INVALID_PARAMETER:
   strcpy(strError, "Invalid parameter given.");
    break;
  case SCARD_E_INVALID_TARGET:
   strcpy(strError, "Invalid target given.");
    break;
  case SCARD_E_INVALID_VALUE:
   strcpy(strError, "Invalid value given.");
    break;
  case SCARD_E_NO_MEMORY:
   strcpy(strError, "Not enough memory.");
    break;
  case SCARD_F_COMM_ERROR:
   strcpy(strError, "RPC transport error.");
    break;
  case SCARD_F_INTERNAL_ERROR:
   strcpy(strError, "Unknown internal error.");
    break;
  case SCARD_F_UNKNOWN_ERROR:
   strcpy(strError, "Unknown internal error.");
    break;
  case SCARD_F_WAITED_TOO_LONG:
   strcpy(strError, "Waited too long.");
    break;
  case SCARD_E_UNKNOWN_READER:
   strcpy(strError, "Unknown reader specified.");
    break;
  case SCARD_E_TIMEOUT:
   strcpy(strError, "Command timeout.");
    break;
  case SCARD_E_SHARING_VIOLATION:
   strcpy(strError, "Sharing violation.");
    break;
  case SCARD_E_NO_SMARTCARD:
   strcpy(strError, "No smartcard inserted.");
    break;
  case SCARD_E_UNKNOWN_CARD:
   strcpy(strError, "Unknown card.");
    break;
  case SCARD_E_PROTO_MISMATCH:
   strcpy(strError, "Card protocol mismatch.");
    break;
  case SCARD_E_NOT_READY:
   strcpy(strError, "Subsystem not ready.");
    break;
  case SCARD_E_SYSTEM_CANCELLED:
   strcpy(strError, "System cancelled.");
    break;
  case SCARD_E_NOT_TRANSACTED:
   strcpy(strError, "Transaction failed.");
    break;
  case SCARD_E_READER_UNAVAILABLE:
   strcpy(strError, "Reader/s is unavailable.");
    break;
  case SCARD_W_UNSUPPORTED_CARD:
   strcpy(strError, "Card is not supported.");
    break;
  case SCARD_W_UNRESPONSIVE_CARD:
   strcpy(strError, "Card is unresponsive.");
    break;
  case SCARD_W_UNPOWERED_CARD:
   strcpy(strError, "Card is unpowered.");
    break;
  case SCARD_W_RESET_CARD:
   strcpy(strError, "Card was reset.");
    break;
  case SCARD_W_REMOVED_CARD:
   strcpy(strError, "Card was removed.");
    break;
  case SCARD_W_INSERTED_CARD:
   strcpy(strError, "Card was inserted.");
    break;
  case SCARD_E_UNSUPPORTED_FEATURE:
   strcpy(strError, "Feature not supported.");
    break;
  case SCARD_E_PCI_TOO_SMALL:
    strcpy(strError, "PCI struct too small.");
    break;
  case SCARD_E_READER_UNSUPPORTED:
   strcpy(strError, "Reader is unsupported.");
    break;
  case SCARD_E_DUPLICATE_READER:
   strcpy(strError, "Reader already exists.");
    break;
  case SCARD_E_CARD_UNSUPPORTED:
   strcpy(strError, "Card is unsupported.");
    break;
  case SCARD_E_NO_SERVICE:
   strcpy(strError, "Service not available.");
    break;
  case SCARD_E_SERVICE_STOPPED:
    strcpy(strError, "Service was stopped.");
    break;

  };

  return strError;
}

