// -*- c++ -*-
//
// $Id: PctestIpv6Icmp.h,v 1.1 2001/01/08 21:31:22 bmah Exp $
//
// PctestIpv6Icmp.h
// Bruce A. Mah <bmah@acm.org>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Header class for IPv6 tests using ICMP
//

#ifndef PCTESTIPV6ICMP_H
#define PCTESTIPV6ICMP_H

#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#if STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#if HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */

#include "pc.h"
#include "PctestIpv6.h"

class PctestIpv6Icmp : public PctestIpv6 {

  public:

    PctestIpv6Icmp() { 
	PctestIpv6Icmp(0);
    };
    PctestIpv6Icmp(int p) { 
	icmp6Id = (u_short) getpid(); // cache PID for ICMP ID field
	icmp6Sequence = 0;	// init sequence number
    };
    virtual ~PctestIpv6Icmp() { 
    };

    virtual int GetSocketOut();
    virtual int Test(TestRecord &tr);
    virtual int GetMinSize();
    virtual PctestActionType GetAction(int icmp6_type, int icmp6_code);
   
  protected:
    u_short icmp6Id;		// ICMP ID
    u_short icmp6Sequence;	// ICMP sequence number

};

#endif /* PCTESTIPV6ICMP_H */
