// -*- c++ -*-
// $Id: pc.h,v 1.18 2000/01/19 17:14:43 bmah Exp $
//
// pc.h
// Bruce A. Mah <bmah@ca.sandia.gov>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Global definitions, macros, and so forth
//

#ifndef PC_H
#define PC_H

// Debugging macros
extern int DebugLevel;
#define IF_DEBUG(level, action) if (DebugLevel >= level) { action; }

// bool type might not be available everywhere
#if (SIZEOF_BOOL == 0)
typedef enum {false, true} bool;
#endif /* SIZEOF_BOOL */

// Network protocol types
typedef enum {
    NetworkProtocolNone,
    NetworkProtocolIpv4Udp,
    NetworkProtocolIpv4Raw,
    NetworkProtocolIpv4File
#ifdef HAVE_IPV6
    ,
    NetworkProtocolIpv6Udp,
    NetworkProtocolIpv6Raw,
    NetworkProtocolIpv6File
#endif /* HAVE_IPV6 */
} NetworkProtocolType;

// Analysis types
typedef enum {
    AnalysisNone,
    AnalysisLeastSquares,
    AnalysisKendall
} AnalysisType;

// Gap types
typedef enum {
    GapNone,
    GapFixed,
    GapExponential
} GapType;

// Linux networking compatability macros.  For some unfathomable
// reason, Linux systems seem to have named many of their networking
// constants differently than those used by virtually every other
// sockets API implementation.  We try to bring it in line with
// the more widely-used sockets API standards here.
#ifdef linux

// We already did a check for <features.h> at configure time, in which
// case we tried to turn on _BSD_SOURCE.  Pull in <features.h>
// again just in case no one did it so far.  #include files should
// be idempotent anyways.
#include <features.h>

// Pre-glibc2 systems may not have the bsd-backward-compatability
// macro.
#if !(defined(__GLIBC__) && (__GLIBC__ >= 2))

// IP
#define ip_sum			ip_csum

// ICMP
#define icmp			icmphdr
#define	icmp_type		type
#define icmp_code		code

#define ICMP_UNREACH		ICMP_DEST_UNREACH
#define ICMP_UNREACH_PORT	ICMP_PORT_UNREACH
#define ICMP_UNREACH_FILTER_PROHIB	ICMP_PKT_FILTERED

#define ICMP_TIMXCEED		ICMP_TIME_EXCEEDED

// UDP
#define	uh_sport		source
#define	uh_dport		dest
#define	uh_ulen			len
#define uh_sum			check

#endif /* glibc */
#endif /* linux */

// Make sure we have a definition for the maximum IP packet size.
// Apparently some Linux systems don't have this defined.
#ifndef IP_MAXPACKET
#define IP_MAXPACKET		65536
#endif /* IP_MAXPACKET */

// Define ICMP unreachable codes that might not be otherwise
// available.  (Solaris 2.5.1 and 2.6 have this problem.)
#define ICMP_UNREACH_FILTER_PROHIB	13

// Solaris 2.5.1 (and earlier?) for some reason is lacking the 
// prototype for random(3).  We give them one.
#ifdef NEED_RANDOM_PROTO
extern "C" {
    long random(void);
}
#endif /* NEED_RANDOM_PROTO */

#endif /* PC_H */

