/* $Id: pkgquery.h,v 1.2 2004/09/29 03:53:58 igor Exp $*/

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __PKGQUERY_H__
#define __PKGQUERY_H__

#include <glib.h>
#include <glib-object.h>

#define TYPE_PKGQUERY			(pkgquery_get_type())
#define PKGQUERY(obj)  			(G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PKGQUERY, PkgQuery))
#define PKGQUERY_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PKGQUERY, PkgQueryClass))
#define IS_PKGQUERY(obj) 		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PKGQUERY))
#define IS_PKGQUERY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PKGQUERY))
#define PKGQUERY_GET_CLASS(obj)  	(G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PKGQUERY, PkgQueryClass))

typedef struct _PkgQuery 	PkgQuery;
typedef struct _PkgQueryClass	PkgQueryClass;

/* PkgQuery Attributes */
struct _PkgQuery
{
	GObject	 g_object_instance;	
	Boolean	 case_sens;		
	char 	*q_name;
	char 	*q_comment;
	char 	*q_edesc;
	char 	*q_sall;
	char 	*q_rdep;
	char 	*q_bdep;				
#ifdef __OpenBSD__
	char 	*q_ldep;
#endif		
};

/* PkgQuery Methods */
struct _PkgQueryClass
{
	GObjectClass	g_object_class;
};

/* PROTOTYPES */
__BEGIN_DECLS
/* pkgquery.c */
GType	 	 pkgquery_get_type(void) G_GNUC_CONST;
PkgQuery	*pkgquery_clone(PkgQuery *);
void		 pkgquery_clear(PkgQuery *);
/* getter|setter functions */
void	 	 pkgquery_set_qname(PkgQuery *, const char *);
void	 	 pkgquery_set_qcomment(PkgQuery *, const char *);
void	 	 pkgquery_set_qedesc(PkgQuery *, const char *);
void	 	 pkgquery_set_qsall(PkgQuery *, const char *);
void	 	 pkgquery_set_qrdep(PkgQuery *, const char *);
void	 	 pkgquery_set_qbdep(PkgQuery *, const char *);
char		*pkgquery_get_qname(PkgQuery *);
char		*pkgquery_get_qcomment(PkgQuery *);
char		*pkgquery_get_qedesc(PkgQuery *);
char		*pkgquery_get_qsall(PkgQuery *);
char		*pkgquery_get_qrdep(PkgQuery *);
char		*pkgquery_get_qbdep(PkgQuery *);
Boolean	 	 pkgquery_is_case_sensitive(PkgQuery *);
void	 	 pkgquery_set_case_sensitive(PkgQuery * , Boolean);
Boolean	 	 pkgquery_is_empty(PkgQuery *);
#ifdef __OpenBSD__
void	 	 pkgquery_set_qldep(PkgQuery *, const char *);
char		*pkgquery_get_qldep(PkgQuery *);
#endif /* __OpenBSD__ */
/* other */
size_t	 	 pkgquery_get_number_of_entries(PkgQuery *);
void	 	 pkgquery_print(PkgQuery *);
__END_DECLS

#endif /* __PKGQUERY__ */
