/* $Id: pbutil.h,v 1.3 2004/10/04 02:25:57 igor Exp $*/

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __PBUTIL_H__
#define __PBUTIL_H__

# define STRLCAT(dst, src, dstsize) { \
  	if (strlcat(dst, src, dstsize) >= (dstsize)) \
	    pb_warning("Detected truncation in strlcat() !"); }
# define STRLCPY(dst, src, dstsize) { \
  	if (strlcpy(dst, src, dstsize) >= (dstsize)) \
	    pb_warning("Detected truncation in strlcpy() !"); }

/* PROTOTYPES */
__BEGIN_DECLS
/* pbutil.c */
char	*pb_strcasestr(const char *, const char *);
char	*pb_strstrip(char *);
Boolean	 pb_compare(char *, char *, Boolean);
__END_DECLS

#endif /* __PBUTIL_H__ */
