/* $Id: pbutil.c,v 1.3 2004/09/29 03:53:58 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <ctype.h>
#include <string.h>

#include "macros.h"
#include "pbutil.h"

/**
 * Case insensitive strstr.
 */
char           *
pb_strcasestr(const char *s, const char *find)
{
	char            c, sc;
	size_t          len;

	if ((c = *find++) != 0) {
		len = strlen(find);
		do {
			do {
				if ((sc = *s++) == 0)
					return (NULL);
			} while (tolower(sc) != tolower(c));
		} while (strncasecmp(s, find, len) != 0);
		s--;
	}
	return (char *) s;
}

/**
 * Removes leading and trailing whitespaces.
 */
char           *
pb_strstrip(char *str)
{
	char           *c;
	size_t          len;

	/* Strip whitespaces from front */
	for (c = str; *c && isspace(*c); c++);
	memmove(str, c, strlen(c) + 1);
	/* Strip whitespaces from back */
	len = strlen(str);
	while (len--) {
		if (isspace(str[len]))
			str[len] = '\0';
		else
			break;
	}
	return str;
}

/**
 * If *second is found in *first the "comparison" was successful.
 */
Boolean
pb_compare(char *haystack, char *needle, Boolean casesens)
{
	char           *retc;

	if (!(haystack) || !(needle))
		return FALSE;
	if (haystack == '\0' || needle == '\0')
		return FALSE;
	if (casesens)
		retc = strstr(haystack, needle);
	else
		retc = pb_strcasestr(haystack, needle);
	return (retc != NULL);
}
