/* $Id: main.c,v 1.23 2004/11/14 17:25:19 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/queue.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "macros.h"
#include "fail.h"
#include "pbutil.h"
#include "pkgobject.h"
#include "pkgquery.h"
#include "pkgcmd.h"
#include "interface.h"

/* PROTOTYPES */
void            usage(void);
#ifndef DEBUG
void            limit_core(void);
#endif

extern char    *__progname;

/**
 *  All the evil stuff starts here.
 */
int
main(int argc, char **argv)
{
	PBWindow       *pb;
	PBSearchWindow *pbs;
	int             ch;

#ifndef DEBUG
	limit_core();
#endif
	if (getuid() == 0)
		pb_error(1, "DO NOT RUN THIS PROGRAM WITH ROOT PRIVILEGES.");
	/* get the g_object and g_tread stuff running */
	if (!g_thread_supported())
		g_thread_init(NULL);
	g_type_init();
	pb_pkg_path_set(DEFAULT_URI);
	pb_set_verbose_level(0);
	while ((ch = getopt(argc, argv, "alvhsp:")) != -1) {
		switch (ch) {
		case 'a':
		  	if (!pb_auth_type_is_sudo())
				pb_auth_once_set(FALSE);
			break;
		case 'h':
			usage();
			break;
		case 'p':
			pb_pkg_path_set(optarg);
			break;
		case 'l':
			pb_set_verbose_level(2);
			break;
		case 'v':
			pb_set_verbose_level(1);
			break;
		case 's':
			pb_auth_once_set(TRUE);
			pb_auth_use_sudo(TRUE);
			break;
		case '?':
			usage();
			break;
		default:
			break;
		}
	}
	if (pkgobject_parse_package_list()) {
		/* start GTK+ machinery */
		gtk_init(&argc, &argv);
		gtk_set_locale();
		if (!(pb = (PBWindow *) calloc(1, sizeof(PBWindow))))
			pb_error(1, strerror(errno));
		if (!(pbs = (PBSearchWindow *) calloc(1, sizeof(PBSearchWindow))))
			pb_error(1, strerror(errno));
		pb->search_window = pbs;
		create_main_window(pb);
		gtk_main();
		FREE(pbs);
		FREE(pb);
		exit(0);
	}
	exit(1);
}

/**
 * print usage().
 */
void
usage(void)
{
	fprintf(stdout, "usage: %s [-ahlsv] [-pPKG_PATH]\n", __progname);
	exit(0);
}

#ifndef DEBUG
/**
 * Limit core dumps - we do not dump core if we are not in DEBUG mode.
 */
void
limit_core(void)
{
	struct rlimit   rlim;

	rlim.rlim_cur = rlim.rlim_max = 0;
	setrlimit(RLIMIT_CORE, &rlim);
}
#endif				/* DEBUG */
