/* $Id: interface.c,v 1.25 2004/11/13 12:42:10 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/stat.h>
#include <sys/types.h>

#include <pwd.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "fail.h"
#include "macros.h"
#include "pkgobject.h"
#include "pkgquery.h"
#include "pkgcmd.h"
#include "callbacks.h"
#include "interface.h"
#include "gtkutil.h"


/* PROTOTYPES */
static void     create_menu(PBWindow *, GtkWidget *);
static void     create_table_general(PBWindow *, GtkWidget *);
static void     create_toolbar(PBWindow *, GtkWidget *);
static void     create_buttons(PBWindow *, GtkWidget *);
static void     connect_signals(PBWindow *);

/**
 * Create the main WINDOW.
 */
GtkWidget      *
create_main_window(PBWindow * pb)
{
	GdkColor        color;
	/* VBox, HBox stuff */
	GtkWidget      *vbox_tab1, *vbox_tab2, *vbox_tab3, *vbox_table;
	GtkWidget      *vbox_main, *hpane_tree_notebook, *hbox_buttons;
	/* GtkFrame */
	GtkFrame       *f_pkg, *f_bdep, *f_rdep, *f_plist;
	/* ScrollWindows */
	GtkWidget      *scr_win_plist;
	GtkWidget      *scr_win_bdep;
	GtkWidget      *scr_win_rdep;
	/* GtkNotebook */
	GtkNotebook    *notebook;
	/* GtkLabels */
	GtkWidget      *l_info, *l_dep, *l_plist;
#ifdef __OpenBSD__
	GtkWidget      *scr_win_ldep;
	GtkFrame       *f_ldep;
#endif				/* __OpenBSD__ */

	gdk_color_parse("red", &color);
	/* INIT THE SEARCH ACTIVE VARIABLE */
	pb->search_active = FALSE;
	/* MAIN WINDOW */
	pb->main_window = g_object_new(GTK_TYPE_WINDOW,
				       "default-height", WINDOWHEIGHT,
				       "title", WINTITLE,
				       NULL);
	/* ACCELERATORS */
	pb->accel_group = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(pb->main_window), pb->accel_group);
	/* SCROLLED WINDOW HOLDING TREEVIEW */
	pb->scr_win_tree = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
					"hscrollbar-policy", GTK_POLICY_NEVER,
				        "vscrollbar-policy", GTK_POLICY_AUTOMATIC,
					NULL);
	/* CREATE STATUSBAR */
	pb->statusbar = g_object_new(GTK_TYPE_STATUSBAR, NULL);
	vbox_main = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(vbox_main);
	gtk_container_add(GTK_CONTAINER(pb->main_window), vbox_main);
	/* MENU STUFF */
	create_menu(pb, vbox_main);
	/* TOOLBAR STUFF */
	create_toolbar(pb, vbox_main);
	/* HORIZONTAL BOX seperating TREE VIEW from NOTEBOOK */
	hpane_tree_notebook = g_object_new(GTK_TYPE_HPANED, NULL);
	gtk_box_pack_start(GTK_BOX(vbox_main), hpane_tree_notebook,
			   TRUE, TRUE, 3);
	/* TREEVIEW STUFF */
	create_treeview(pb);
	gtk_paned_pack1(GTK_PANED(hpane_tree_notebook), pb->scr_win_tree, TRUE, FALSE);
	/* VBOX holding INSTALL BUTTONS and NOTEBOOK */
	pb->vbox_notebook = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(pb->vbox_notebook);
	gtk_paned_pack2(GTK_PANED(hpane_tree_notebook), pb->vbox_notebook, TRUE, FALSE);
	gtk_widget_show(hpane_tree_notebook);
	/* NOTEBOOK */
	notebook = g_object_new(GTK_TYPE_NOTEBOOK,
				"homogeneous", TRUE,
				NULL);
	gtk_widget_show(GTK_WIDGET(notebook));
	gtk_box_pack_start(GTK_BOX(pb->vbox_notebook), GTK_WIDGET(notebook),
			   TRUE, TRUE, 0);
	/* CREATE BUTTONS */
	hbox_buttons = g_object_new(GTK_TYPE_HBUTTON_BOX, NULL);
	gtk_box_set_spacing(GTK_BOX(hbox_buttons), 5);
	gtk_container_set_border_width(GTK_CONTAINER(hbox_buttons), 5);
	create_buttons(pb, hbox_buttons);
	gtk_box_pack_start(GTK_BOX(pb->vbox_notebook), hbox_buttons,
			   FALSE, FALSE, 0);
	/* TABPAGE ONE */
	vbox_tab1 = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(vbox_tab1);
	gtk_container_add(GTK_CONTAINER(notebook), vbox_tab1);
	/* FRAME 1 */
	f_pkg = g_object_new(GTK_TYPE_FRAME,
			     "label", "Package Information",
			     NULL);
	gtk_widget_show(GTK_WIDGET(f_pkg));
	gtk_box_pack_start(GTK_BOX(vbox_tab1),
			   GTK_WIDGET(f_pkg), TRUE, TRUE, 6);

	vbox_table = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(GTK_WIDGET(vbox_table));
	gtk_container_add(GTK_CONTAINER(f_pkg), vbox_table);
	/* CREATE THE TABLE */
	create_table_general(pb, vbox_table);

	l_info = g_object_new(GTK_TYPE_LABEL,
			      "label", "General",
			      NULL);
	gtk_widget_show(l_info);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			 gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 0),
				   l_info);
	/* TABPAGE 2 */
	vbox_tab2 = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(vbox_tab2);
	gtk_container_add(GTK_CONTAINER(notebook), vbox_tab2);
	/* RUN DEPENDENCIES */
	f_rdep = g_object_new(GTK_TYPE_FRAME,
			      "label", "Run dependencies",
			      NULL);
	gtk_widget_show(GTK_WIDGET(f_rdep));
	gtk_box_pack_start(GTK_BOX(vbox_tab2), GTK_WIDGET(f_rdep),
			   TRUE, TRUE, 6);
	scr_win_rdep = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
				    "hscrollbar-policy", GTK_POLICY_AUTOMATIC,
				    "shadow-type", GTK_SHADOW_IN,
				    NULL);
	gtk_widget_show(scr_win_rdep);
	gtk_container_add(GTK_CONTAINER(f_rdep), scr_win_rdep);
	pb->txtv_rdep = g_object_new(GTK_TYPE_TEXT_VIEW,
				     "cursor-visible", FALSE,
				     "editable", FALSE,
				     "left-margin", 10,
				     "wrap-mode", GTK_WRAP_WORD,
				     NULL);
	gtk_widget_show(GTK_WIDGET(pb->txtv_rdep));
	gtk_container_add(GTK_CONTAINER(scr_win_rdep),
			  GTK_WIDGET(pb->txtv_rdep));
#ifdef __OpenBSD__
	/* LIBRARY DEPENDENCIES - FreeBSD doesn't have this */
	f_ldep = g_object_new(GTK_TYPE_FRAME,
			      "label", "Library dependencies",
			      NULL);
	gtk_widget_show(GTK_WIDGET(f_ldep));
	gtk_box_pack_start(GTK_BOX(vbox_tab2),
			   GTK_WIDGET(f_ldep), TRUE, TRUE, 6);
	scr_win_ldep = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
				    "hscrollbar-policy", GTK_POLICY_AUTOMATIC,
				    "shadow-type", GTK_SHADOW_IN,
				    NULL);
	gtk_widget_show(scr_win_ldep);
	gtk_container_add(GTK_CONTAINER(f_ldep), scr_win_ldep);
	pb->txtv_ldep = g_object_new(GTK_TYPE_TEXT_VIEW,
				     "cursor-visible", FALSE,
				     "editable", FALSE,
				     "left-margin", 10,
				     "wrap-mode", GTK_WRAP_WORD,
				     NULL);
	gtk_widget_show(GTK_WIDGET(pb->txtv_ldep));
	gtk_container_add(GTK_CONTAINER(scr_win_ldep),
			  GTK_WIDGET(pb->txtv_ldep));
#endif				/* __OpenBSD__ */
	/* BUILD DEPENDENCIES */
	f_bdep = g_object_new(GTK_TYPE_FRAME,
			      "label", "Build dependencies",
			      NULL);
	gtk_box_pack_start(GTK_BOX(vbox_tab2), GTK_WIDGET(f_bdep),
			   TRUE, TRUE, 6);
	scr_win_bdep = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
				    "hscrollbar-policy", GTK_POLICY_AUTOMATIC,
				    "shadow-type", GTK_SHADOW_IN,
				    NULL);
	gtk_widget_show(scr_win_bdep);
	gtk_container_add(GTK_CONTAINER(f_bdep), scr_win_bdep);
	pb->txtv_bdep = g_object_new(GTK_TYPE_TEXT_VIEW,
				     "cursor-visible", FALSE,
				     "editable", FALSE,
				     "left-margin", 10,
				     "wrap-mode", GTK_WRAP_WORD,
				     NULL);
	gtk_widget_show(GTK_WIDGET(pb->txtv_bdep));
	gtk_container_add(GTK_CONTAINER(scr_win_bdep),
			  GTK_WIDGET(pb->txtv_bdep));
	l_dep = g_object_new(GTK_TYPE_LABEL,
			     "label", "Dependencies",
			     NULL);
	gtk_widget_show(l_dep);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			 gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 1),
				   l_dep);
	/* TABPAGE 3 */
	vbox_tab3 = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(vbox_tab3);
	gtk_container_add(GTK_CONTAINER(notebook), vbox_tab3);
	f_plist = g_object_new(GTK_TYPE_FRAME,
			       "label", "Package filelist",
			       NULL);
	gtk_box_pack_start(GTK_BOX(vbox_tab3), GTK_WIDGET(f_plist),
			   TRUE, TRUE, 6);
	scr_win_plist = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
				     "hscrollbar-policy", GTK_POLICY_AUTOMATIC,
				     "shadow-type", GTK_SHADOW_IN,
				     NULL);
	gtk_widget_show(scr_win_plist);
	gtk_container_add(GTK_CONTAINER(f_plist), scr_win_plist);
	pb->txtv_plist = g_object_new(GTK_TYPE_TEXT_VIEW,
				      "cursor-visible", FALSE,
				      "editable", FALSE,
				      "left-margin", 10,
				      "wrap-mode", GTK_WRAP_WORD,
				      NULL);
	gtk_widget_show(GTK_WIDGET(pb->txtv_plist));
	gtk_container_add(GTK_CONTAINER(scr_win_plist),
			  GTK_WIDGET(pb->txtv_plist));
	l_plist = g_object_new(GTK_TYPE_LABEL,
			       "label", "Filelist",
			       NULL);
	gtk_widget_show(l_plist);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			 gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 2),
				   l_plist);
	/* GET POINTERS TO TEXT BUFFERS */
	pb->txtb_rdep = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pb->txtv_rdep));
	gtk_widget_modify_text(GTK_WIDGET(pb->txtv_rdep), GTK_STATE_NORMAL, &color);
	pb->txtb_bdep = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pb->txtv_bdep));
	gtk_widget_modify_text(GTK_WIDGET(pb->txtv_bdep), GTK_STATE_NORMAL, &color);
	pb->txtb_plist = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pb->txtv_plist));
	pb->txtb_ldesc = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pb->txtv_ldesc));
#ifdef __OpenBSD__
	pb->txtb_ldep = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pb->txtv_ldep));
	gtk_widget_modify_text(GTK_WIDGET(pb->txtv_ldep), GTK_STATE_NORMAL, &color);
#endif
	/* STATUSBAR */
	gtk_widget_show(GTK_WIDGET(pb->statusbar));
	gtk_box_pack_start(GTK_BOX(vbox_main), GTK_WIDGET(pb->statusbar),
			   FALSE, FALSE, 0);
	/* ADD MESSAGE TO STATUS BAR */
	pb_set_statusbar_text(pb->statusbar,
			      "Ports Statistics: %d Ports available, "
			      "%d Ports installed",
			      pkgobject_get_list_size(),
			      pkgobject_get_number_installed_packages());
	/* FINALLY CONNECT ALL THE SIGNALS */
	connect_signals(pb);
	gtk_widget_show_all(GTK_WIDGET(pb->main_window));
	/*
	 * XXX: This is a nasty HACK and what it does is prevent the hpane
	 * divider to suddenly make the treeview totally small after changing
	 * the tree views scrolled window policy.
	 */
	gtk_paned_set_position(GTK_PANED(hpane_tree_notebook),
		      gtk_paned_get_position(GTK_PANED(hpane_tree_notebook)));
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(pb->scr_win_tree),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	return pb->main_window;
}

/**
 * Setup all the signals.
 */
static void
connect_signals(PBWindow * pb)
{
	g_signal_connect(pb->main_window,
			 "delete_event", G_CALLBACK(delete_event),
			 NULL);
	g_signal_connect(pb->main_window,
			 "destroy", G_CALLBACK(end_event),
			 NULL);
	/* INSTALL|UNISTALL Buttons */
	g_signal_connect(pb->b_iport,
			 "clicked", G_CALLBACK(port_install_function),
			 pb);
	g_signal_connect(pb->b_ipkg,
			 "clicked", G_CALLBACK(port_install_function),
			 pb);
	g_signal_connect(pb->b_dpkg,
			 "clicked", G_CALLBACK(port_install_function),
			 pb);
	g_signal_connect(pb->b_dpkgf,
			 "clicked", G_CALLBACK(port_install_function),
			 pb);
}

static void
create_buttons(PBWindow * pb, GtkWidget *hbox_buttons)
{
	pb->b_iport = pb_create_custom_button(IMAGEDIR "pb-install_port.png",
					      "Install _Port");
	pb->b_ipkg = pb_create_custom_button(IMAGEDIR "pb-install_pkg.png",
					     "_Install Package");
	pb->b_dpkg = pb_create_custom_button(IMAGEDIR "pb-uninstall.png",
					     "De_lete");
	pb->b_dpkgf = pb_create_custom_button(IMAGEDIR "pb-uninstall_force.png",
					      "Force _Delete");
	/*
	 * XXX: We do give the buttons names so we only need one callback
	 * function which can distinguish which button was pressed by the
	 * property "name". That way we must not duplicate that much code in
	 * callbacks.c
	 */
	g_object_set_data(G_OBJECT(pb->b_iport), "inst_type",
			  GINT_TO_POINTER(PB_PKGCMD_INST_PORT));

	g_object_set_data(G_OBJECT(pb->b_ipkg), "inst_type",
			  GINT_TO_POINTER(PB_PKGCMD_INST_PKG));

	g_object_set_data(G_OBJECT(pb->b_dpkg), "inst_type",
			  GINT_TO_POINTER(PB_PKGCMD_DEL_PKG));

	g_object_set_data(G_OBJECT(pb->b_dpkgf), "inst_type",
			  GINT_TO_POINTER(PB_PKGCMD_DELF_PKG));

	/* HBUTTON_BOX for the Buttons */
	gtk_container_add(GTK_CONTAINER(hbox_buttons), pb->b_iport);
	gtk_container_add(GTK_CONTAINER(hbox_buttons), pb->b_ipkg);
	gtk_container_add(GTK_CONTAINER(hbox_buttons), pb->b_dpkg);
	gtk_container_add(GTK_CONTAINER(hbox_buttons), pb->b_dpkgf);
	gtk_widget_show_all(hbox_buttons);
}

/**
 * Create toolbar and connect signals of toolbar buttons.
 */
static void
create_toolbar(PBWindow * pb, GtkWidget *vbox_main)
{
	GtkWidget      *vbox_toolbar;

	vbox_toolbar = g_object_new(GTK_TYPE_VBOX, NULL);
	gtk_widget_show(vbox_toolbar);
	gtk_box_pack_start(GTK_BOX(vbox_main), vbox_toolbar,
			   FALSE, FALSE, 0);
	pb->toolbar = g_object_new(GTK_TYPE_TOOLBAR,
				   "toolbar-style", GTK_TOOLBAR_BOTH,
				   NULL);
	gtk_widget_show(GTK_WIDGET(pb->toolbar));
	gtk_box_pack_start(GTK_BOX(vbox_toolbar), GTK_WIDGET(pb->toolbar),
			   FALSE, FALSE, 0);
	/* GTK TOOLBAR STOCK ITEMS */
	pb->t_backward = gtk_toolbar_insert_stock(pb->toolbar,
						  GTK_STOCK_GO_BACK,
						  NULL, NULL,
				      G_CALLBACK(treeview_previous_selection),
						  pb, -1);
	pb->t_forward = gtk_toolbar_insert_stock(pb->toolbar,
						 GTK_STOCK_GO_FORWARD,
						 NULL, NULL,
					  G_CALLBACK(treeview_next_selection),
						 pb, -1);
	gtk_toolbar_append_space(pb->toolbar);
	pb->t_refresh = gtk_toolbar_insert_stock(pb->toolbar,
						 GTK_STOCK_REFRESH,
						 "Refresh package list",
						 NULL,
					   G_CALLBACK(treeview_refresh_event),
						 pb,
						 -1);
	pb->t_refresh = gtk_toolbar_insert_stock(pb->toolbar,
						 GTK_STOCK_FIND,
						 "Ports Search",
						 NULL,
					     G_CALLBACK(search_create_widget),
						 pb, -1);
	/* ADD ACCELERATORS */
	gtk_widget_add_accelerator(pb->t_forward, "clicked", pb->accel_group,
			       GDK_Down, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator(pb->t_backward, "clicked", pb->accel_group,
				 GDK_Up, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
}

/**
 * Create the table in the general tab. There are some #ifdefs since
 * some stuff is Open|FreeBSD specific like Multipackages and
 * Flavours.
 */
static void
create_table_general(PBWindow * pb, GtkWidget *vbox_table)
{
	GtkWidget      *scr_win_ldesc;
	GtkWidget      *table;
	GtkWidget      *l_pkg, *l_dir, *l_sdesc, *l_cat, *l_edesc;
#ifdef __OpenBSD__
	GtkWidget      *l_multi, *l_flav;

	table = gtk_table_new(7, 2, FALSE);
#else
	GtkWidget      *l_www;

	table = gtk_table_new(6, 2, FALSE);
#endif
	gtk_widget_show(table);
	gtk_box_pack_start(GTK_BOX(vbox_table), table,
			   TRUE, TRUE, 6);
	gtk_table_set_row_spacings(GTK_TABLE(table), 3);
	gtk_table_set_col_spacings(GTK_TABLE(table), 3);


	scr_win_ldesc = g_object_new(GTK_TYPE_SCROLLED_WINDOW,
				     "hscrollbar-policy", GTK_POLICY_AUTOMATIC,
				     "shadow-type", GTK_SHADOW_IN,
				     NULL);
	gtk_widget_show(scr_win_ldesc);
	pb->txtv_ldesc = g_object_new(GTK_TYPE_TEXT_VIEW,
				      "cursor-visible", FALSE,
				      "editable", FALSE,
				      "left-margin", 10,
				      NULL);
	gtk_widget_show(GTK_WIDGET(pb->txtv_ldesc));
	gtk_container_add(GTK_CONTAINER(scr_win_ldesc),
			  GTK_WIDGET(pb->txtv_ldesc));
	gtk_widget_show(GTK_WIDGET(scr_win_ldesc));
#ifdef __OpenBSD__
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(scr_win_ldesc), 1, 2, 6, 7,
			 (GTK_EXPAND | GTK_FILL),
			 (GTK_EXPAND | GTK_FILL), 3, 0);

	pb->e_multi = g_object_new(GTK_TYPE_ENTRY,
				   "editable", FALSE,
				   NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_multi));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_multi), 1, 2, 5, 6,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	pb->e_flav = g_object_new(GTK_TYPE_ENTRY,
				  "editable", FALSE,
				  NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_flav));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_flav), 1, 2, 4, 5,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
#else
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(scr_win_ldesc), 1, 2, 5, 6,
			 (GTK_EXPAND | GTK_FILL),
			 (GTK_EXPAND | GTK_FILL), 3, 0);

	pb->e_www = g_object_new(GTK_TYPE_ENTRY,
				 "editable", FALSE,
				 NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_www));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_www), 1, 2, 4, 5,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
#endif
	pb->e_dir = g_object_new(GTK_TYPE_ENTRY,
				 "editable", FALSE,
				 NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_dir));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_dir), 1, 2, 3, 4,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
	pb->e_cat = g_object_new(GTK_TYPE_ENTRY,
				 "editable", FALSE,
				 NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_dir));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_cat), 1, 2, 2, 3,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
	pb->e_sdesc = g_object_new(GTK_TYPE_ENTRY,
				   "editable", FALSE,
				   NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_sdesc));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_sdesc), 1, 2, 1, 2,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
	pb->e_name = g_object_new(GTK_TYPE_ENTRY,
				  "editable", FALSE,
				  NULL);
	gtk_widget_show(GTK_WIDGET(pb->e_name));
	gtk_table_attach(GTK_TABLE(table),
			 GTK_WIDGET(pb->e_name), 1, 2, 0, 1,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 3, 0);
	/* LABELS IN THE TABLE */
	l_pkg = g_object_new(GTK_TYPE_LABEL,
			     "label", "Name:",
			     NULL);
	gtk_widget_show(l_pkg);
	gtk_table_attach(GTK_TABLE(table), l_pkg, 0, 1, 0, 1,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_pkg), 0, 0.5);
	l_sdesc = g_object_new(GTK_TYPE_LABEL,
			       "label", "Comment:",
			       NULL);
	gtk_widget_show(l_sdesc);
	gtk_table_attach(GTK_TABLE(table), l_sdesc, 0, 1, 1, 2,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_sdesc), 0, 0.5);
	l_cat = g_object_new(GTK_TYPE_LABEL,
			     "label", "Category:",
			     NULL);
	gtk_widget_show(l_cat);
	gtk_table_attach(GTK_TABLE(table), l_cat, 0, 1, 2, 3,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_cat), 0, 0.5);
	l_dir = g_object_new(GTK_TYPE_LABEL,
			     "label", "Directory:",
			     NULL);
	gtk_widget_show(l_dir);
	gtk_table_attach(GTK_TABLE(table), l_dir, 0, 1, 3, 4,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_dir), 0, 0.5);
#ifdef __OpenBSD__
	l_flav = g_object_new(GTK_TYPE_LABEL,
			      "label", "Flavor:",
			      NULL);
	gtk_widget_show(l_flav);
	gtk_table_attach(GTK_TABLE(table), l_flav, 0, 1, 4, 5,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_flav), 0, 0.5);
	l_multi = g_object_new(GTK_TYPE_LABEL,
			       "label", "Multipackage:",
			       NULL);
	gtk_widget_show(l_multi);
	gtk_table_attach(GTK_TABLE(table), l_multi, 0, 1, 5, 6,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_multi), 0, 0.5);
#else
	l_www = g_object_new(GTK_TYPE_LABEL,
			     "label", "Homepage:",
			     NULL);
	gtk_table_attach(GTK_TABLE(table), l_www, 0, 1, 4, 5,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
	gtk_misc_set_alignment(GTK_MISC(l_www), 0, 0.5);
#endif
	l_edesc = g_object_new(GTK_TYPE_LABEL,
			       "label", "Description:",
			       NULL);
	gtk_widget_show(l_edesc);
#ifdef __OpenBSD__
	gtk_table_attach(GTK_TABLE(table), l_edesc, 0, 1, 6, 7,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
#else
	gtk_table_attach(GTK_TABLE(table), l_edesc, 0, 1, 5, 6,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 3, 0);
#endif
	gtk_misc_set_alignment(GTK_MISC(l_edesc), 0, 0);
}

/**
 * Create the main menu.
 */
static void
create_menu(PBWindow * pb, GtkWidget *vbox_main)
{
	GtkMenuBar     *menu;
	GtkMenu        *filemenu, *editmenu, *viewmenu, *gomenu;
	GtkWidget      *file, *edit, *go, *view;
	GtkWidget      *seperator1;

	menu = g_object_new(GTK_TYPE_MENU_BAR, NULL);
	/* FILEMENU */
	filemenu = g_object_new(GTK_TYPE_MENU, NULL);
	file = gtk_menu_item_new_with_mnemonic("_File");
	pb_menu_shell_append(filemenu, GTK_STOCK_QUIT,
			     "activate", G_CALLBACK(end_event), NULL,
			     pb->accel_group, GDK_q);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), file);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), GTK_WIDGET(filemenu));
	/* EDITMENU */
	editmenu = g_object_new(GTK_TYPE_MENU, NULL);
	edit = gtk_menu_item_new_with_mnemonic("_Edit");
	pb_menu_shell_append(editmenu, GTK_STOCK_FIND,
			     "activate", G_CALLBACK(search_create_widget), pb,
			     pb->accel_group, GDK_f);
	pb_menu_shell_append(editmenu, "Package Path",
			     "activate", G_CALLBACK(path_create_widget), pb,
			     NULL, 0);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), edit);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(edit), GTK_WIDGET(editmenu));
	/* GOMENU */
	gomenu = g_object_new(GTK_TYPE_MENU, NULL);
	go = gtk_menu_item_new_with_mnemonic("_Go");
	pb_menu_shell_append(gomenu, GTK_STOCK_GO_FORWARD,
			  "activate", G_CALLBACK(treeview_next_selection), pb,
			     pb->accel_group, GDK_Right);
	pb_menu_shell_append(gomenu, GTK_STOCK_GO_BACK,
		      "activate", G_CALLBACK(treeview_previous_selection), pb,
			     pb->accel_group, GDK_Left);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), go);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(go), GTK_WIDGET(gomenu));
	/* VIEWMENU */
	viewmenu = g_object_new(GTK_TYPE_MENU, NULL);
	view = gtk_menu_item_new_with_mnemonic("_View");
	pb_menu_shell_append(viewmenu, "E_xpand All",
			     "activate", G_CALLBACK(treeview_expand), pb,
			     pb->accel_group, GDK_x);
	pb_menu_shell_append(viewmenu, "C_ollapse All",
			     "activate", G_CALLBACK(treeview_collapse), pb,
			     pb->accel_group, GDK_o);
	seperator1 = gtk_separator_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(viewmenu), seperator1);
	pb_menu_shell_append(viewmenu, GTK_STOCK_REFRESH,
			   "activate", G_CALLBACK(treeview_refresh_event), pb,
			     pb->accel_group, GDK_r);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), view);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(view), GTK_WIDGET(viewmenu));
	/* PACK IT */
	gtk_widget_show(GTK_WIDGET(menu));
	gtk_box_pack_start(GTK_BOX(vbox_main), GTK_WIDGET(menu),
			   FALSE, FALSE, 0);
}

/**
 * Create the package TREE VIEW out of the list created by
 * the parser.
 */
void
create_treeview(PBWindow * pb)
{
	GtkTreeIter     toplevel, child;
	PkgObject      *list_cur, *list_next;
	GtkTreeStore   *treestore;
	GtkTreeView    *treeview;
	GtkTreeSelection *selection;
	GtkTreeViewColumn *column0, *column1, *column2;
	GtkCellRenderer *textrenderer, *radiorenderer;

	if (!pkgobject_is_list_empty()) {
		list_cur = pkgobject_get_list_head();
		list_next = pkgobject_get_list_next(list_cur);
		/* create the treestore */
		treestore = gtk_tree_store_new(N_COLUMNS,
					       G_TYPE_UINT,
					       G_TYPE_STRING,
					       G_TYPE_STRING,
					       G_TYPE_INT);
		/* the first one is surely a top level row entry */
		gtk_tree_store_append(treestore, &toplevel, NULL);
		gtk_tree_store_set(treestore, &toplevel,
				   INT_COL_ID,
				   pkgobject_get_id(list_cur),
				   STRING_COL_CATEGORY,
				   pkgobject_get_category(list_cur),
				   STRING_COL_PKGNAME,
				   pkgobject_get_distrib_name(list_cur),
				   BOOL_COL_INSTALL,
				   pkgobject_get_install_status(list_cur),
				   -1);
		/* ITERATE through the LIST */
		for (list_cur = pkgobject_get_list_next(list_cur); (list_cur);
		     list_cur = pkgobject_get_list_next(list_cur)) {
			if (!strcmp(pkgobject_get_category(list_cur),
				    pkgobject_get_category(list_next))) {
				gtk_tree_store_append(treestore, &child, &toplevel);
				gtk_tree_store_set(treestore, &child,
						   INT_COL_ID,
						   pkgobject_get_id(list_cur),
						   STRING_COL_CATEGORY,
						   NULL,
						   STRING_COL_PKGNAME,
					 pkgobject_get_distrib_name(list_cur),
						   BOOL_COL_INSTALL,
				       pkgobject_get_install_status(list_cur),
						   -1);
			} else {
				/*
				 * else -> we are dealing with another top
				 * level entry
				 */
				gtk_tree_store_append(treestore, &toplevel, NULL);
				gtk_tree_store_set(treestore, &toplevel,
						   INT_COL_ID,
						   pkgobject_get_id(list_cur),
						   STRING_COL_CATEGORY,
					     pkgobject_get_category(list_cur),
						   STRING_COL_PKGNAME,
					 pkgobject_get_distrib_name(list_cur),
						   BOOL_COL_INSTALL,
				       pkgobject_get_install_status(list_cur),
						   -1);
			}
			list_next = list_cur;
		}
		/* CREATE RENDERERS */
		textrenderer = gtk_cell_renderer_text_new();
		radiorenderer = gtk_cell_renderer_toggle_new();
		g_object_set(radiorenderer,
			     "radio", TRUE,
			     NULL);
		/* CREATE COLUMNS */
		column0 = gtk_tree_view_column_new_with_attributes("Category",
								 textrenderer,
								   "text",
							  STRING_COL_CATEGORY,
								   NULL);
		column1 = gtk_tree_view_column_new_with_attributes("Name",
								 textrenderer,
								   "text",
							   STRING_COL_PKGNAME,
								   NULL);
		column2 = gtk_tree_view_column_new_with_attributes("Installed",
								radiorenderer,
								   "active",
							     BOOL_COL_INSTALL,
								   NULL);
		g_object_set(column0,
			     "resizable", TRUE,
			     "clickable", TRUE,
			     NULL);
		g_object_set(column1,
			     "resizable", TRUE,
			     "clickable", TRUE,
			     NULL);
		g_object_set(column2,
			     "resizable", TRUE,
			     "clickable", TRUE,
			     NULL);
		/* CREATE TREE VIEW */
		treeview = g_object_new(GTK_TYPE_TREE_VIEW,
					"model", treestore,
					"rules-hint", TRUE,
					"headers-clickable", TRUE,
					"enable-search", TRUE,
					"search-column", STRING_COL_PKGNAME,
					NULL);
		/* connect the row-activated signal to selection_changed  */
		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
		gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
		/* CONNECT SIGNAL */
		g_signal_connect(G_OBJECT(selection),
			    "changed", G_CALLBACK(treeview_changed_selection),
				 pb);
		/* add COLUMNS to view */
		gtk_tree_view_append_column(treeview, column0);
		gtk_tree_view_append_column(treeview, column2);
		gtk_tree_view_append_column(treeview, column1);
		gtk_tree_view_set_expander_column(treeview, column0);

		gtk_widget_show(GTK_WIDGET(treeview));
		gtk_container_add(GTK_CONTAINER(pb->scr_win_tree),
				  GTK_WIDGET(treeview));
		gtk_widget_show(GTK_WIDGET(pb->scr_win_tree));
	} else {
		treeview = NULL;
	}
}
