/**
 ** Copyright (c) 1996  En Garde Systems, Inc. (EGS) 
 **
 ** Users and possessors of this source code are hereby granted a
 ** nonexclusive, royalty-free copyright and design patent license to
 ** use this code in individual software provided that the above copyright
 ** notice and this paragraph are included in their entirety.  License is
 ** not granted for commercial resale, in whole or in part, without prior
 ** written permission from EGS.  This source is provided "AS IS"
 ** without express or implied warranty of any kind.
 **
 ** In the case of superceding copyright notices, only the modifications to
 ** the original software are covered by this notice.
 **
 ** For further information contact:
 **     E-Mail:     info@EnGarde.com
 **
 **     Surface Mail:   ATTN: PICS Research
 **             En Garde Systems, Inc.
 **             2101 White Cloud NE
 **             Albuquerque, NM 87112
 **             (505) 275-8655
 **/

/*
 * This is part of the TCPdump parser program. The point of this is to plug
 * through an input file, and correlate all the individual TCP sessions for
 * display.
 *
 * XXX-this should do *SOMETHING* with UDP, but it can't really be correlated..
 */

#include <stdio.h>
#include <alloca.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include "pcap.h"
#include "parse.h"

void summarize_handler();
static void summarize_list();

void
summarize_logfile(filename)
char *filename; /* PCAP filename to read from */
{
  char ebuf[PCAP_ERRBUF_SIZE];
  pcap_t *pcp;

  if ((pcp = pcap_open_offline(filename, ebuf)) == NULL) {
	fprintf(stderr, "Can't open input file: %s\n", ebuf);
	exit(1);
  }

  if (pcap_dispatch(pcp, 0, summarize_handler, NULL) < 0) 
	pcap_perror(pcp, "Can't read from input log");
  
  summarize_list();

  pcap_close(pcp);
  return;
}

struct conn_list_struct *ConnectionList=NULL;

#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? a : b)
#endif

void 
summarize_handler(user_data, pkth, p)
u_char *user_data;
struct pcap_pkthdr *pkth;
u_char *p;
{
  struct conn_list_struct *clp, *nlp;
  struct ether_header *ep;
  struct ip *ip;
  struct tcphdr *tcph;
  u_char *abuf, *abuf2;
  u_long src, dst;
  u_short src_port, dst_port;
  int flags, length;

  ep = (struct ether_header *)p;
  p += sizeof(struct ether_header);

  if (ntohs(ep->ether_type) != ETHERTYPE_IP)
	return; /* Skip ARPs and other nasties */

  ip = (struct ip *)p;

  if ((int)ip & (sizeof(long)-1)) {
	/* needs to be aligned */
	abuf = (u_char *)alloca(pkth->caplen);

	bcopy((char *)ip, (char *)abuf, MIN(pkth->len, pkth->caplen));
	ip = (struct ip *)abuf;
  }
  p += ip->ip_hl * 4;

  if ((ntohs(ip->ip_off) & 0x1fff) ||  (ip->ip_p!=IPPROTO_TCP)) 
	return; /* Skip UDP or non-0 offsetted packets */

  tcph = (struct tcphdr *)p;
  if ((int)tcph & (sizeof(long)-1)) {
	/* needs to be aligned */
	abuf2 = (u_char *)alloca(pkth->caplen);

	bcopy((char *)tcph, (char *)abuf2, MIN(pkth->len, pkth->caplen));
	tcph = (struct tcphdr *)abuf2;
  }

  src_port = ntohs(tcph->th_sport);
  dst_port = ntohs(tcph->th_dport);
  src = ntohl(ip->ip_src.s_addr);
  dst = ntohl(ip->ip_dst.s_addr);
  length = htons(ip->ip_len) - (ip->ip_hl * 4);
  length -= (tcph->th_off * 4); /* Subtract TCP header length */

  for (clp = ConnectionList; clp; clp = clp->next) {
	if (clp->src == src && clp->dst == dst && 
		 clp->src_port == src_port && clp->dst_port == dst_port) {
	  clp->src_bytes += length;
	  if (tcph->th_flags & (TH_FIN|TH_RST)) {
		clp->end_time.tv_sec = pkth->ts.tv_sec;
		clp->end_time.tv_usec = pkth->ts.tv_usec;
	  }
	  break;
	}
	if (clp->src == dst && clp->dst == src &&
		 clp->src_port == dst_port && clp->dst_port == src_port) {
	  clp->dst_bytes += length;
	  if (tcph->th_flags & (TH_FIN|TH_RST)) {
		clp->end_time.tv_sec = pkth->ts.tv_sec;
		clp->end_time.tv_usec = pkth->ts.tv_usec;
	  }
	  break;
	}
  }

  if (clp == NULL) {
	nlp = (struct conn_list_struct *)malloc(sizeof(struct conn_list_struct));
	nlp->src = src;
	nlp->dst = dst;
	nlp->src_port = src_port;
	nlp->dst_port = dst_port;
	nlp->src_bytes = length;
	nlp->dst_bytes = 0;

	nlp->start_time.tv_sec = pkth->ts.tv_sec;
	nlp->start_time.tv_usec = pkth->ts.tv_usec;
	nlp->end_time.tv_sec = 0;
	nlp->end_time.tv_usec = 0;

	/* Append to the end of the list for sequential order */
	for (clp = ConnectionList; clp!=NULL && clp->next!=NULL; clp=clp->next) ;
	if (clp == NULL) {
	  nlp->next = NULL;
	  ConnectionList = nlp;
	} else {
	  clp->next = nlp;
	  nlp->next = NULL;
	}
  }
  return;
}

static void 
summarize_list()
{
  struct conn_list_struct *clp;
  struct tm *lt;
  char tbuf[20], tbuf2[20];
  struct hostent *he;
  char host1[80];
  char host2[80];
  struct in_addr in;
  int count=0;
  extern int ignore_zero;

  for (clp=ConnectionList;clp;clp=clp->next) {
	if (ignore_zero && clp->src_bytes == 0 && clp->dst_bytes == 0) {
	  count++;
	  continue;
	}
	lt = localtime((time_t *)&clp->start_time.tv_sec);
	strftime(tbuf, 19, "%D %T", lt);
	if (clp->end_time.tv_sec<=0)
	  strcpy(tbuf2, "END");
	else {
	  lt = localtime((time_t *)&clp->end_time.tv_sec);
	  strftime(tbuf2, 19, "%D %T", lt);
	}
	if ((he = gethostbyaddr((char *)&clp->src, 4, AF_INET)) != NULL) {
	  strncpy(host1, he->h_name, 79);
	} else {
	  in.s_addr = clp->src;
	  strncpy(host1, inet_ntoa(in), 79);
	}
	if ((he = gethostbyaddr((char *)&clp->dst, 4, AF_INET)) != NULL) {
	  strncpy(host2, he->h_name, 79);
	} else {
	  in.s_addr = clp->dst;
	  strncpy(host2, inet_ntoa(in), 79);
	}

	printf("%d) %s..%s:\n\t%s (%d) -> %s (%d) [%d -> %d]\n",
		   count, tbuf, tbuf2, host1, (int)clp->src_port, 
		   host2, (int)clp->dst_port, clp->src_bytes, clp->dst_bytes);
	count++;
  }
  return;
}
